import { CommonModule } from '@angular/common';
import { HttpClientModule } from '@angular/common/http';
import { NgModule } from '@angular/core';
import { FormControlComponent } from './components/form-control/form-control.component';
import { FocusBlurDirective } from './directives/focus-blur.directive';
import { PasswordDirective } from './directives/password.directive';
import { TruncatePipe } from './pipes/truncate.pipe';
import { HttpService } from './services/http.service';
import { UtilsService } from './services/utils.service';

const PIPES = [
  TruncatePipe
];

const COMPONENTS = [
  FormControlComponent
];

const DIRECTIVES = [
  FocusBlurDirective,
  PasswordDirective
];

const PROVIDERS = [
  HttpService,
  UtilsService
];

const MODULES = [
  HttpClientModule
];

@NgModule({
  declarations: [...COMPONENTS, ...DIRECTIVES, ...PIPES],
  imports: [
    CommonModule,
    ...MODULES
  ],
  providers: PROVIDERS,
  exports: [
    ...MODULES,
    ...COMPONENTS,
    ...PIPES,
    ...DIRECTIVES
  ]
})
export class VqodeModule {
}
