import { FormControl, ValidatorFn } from '@angular/forms';

export class ConfirmPasswordValidator {

  static MatchPassword(comparisonValue = ''): ValidatorFn {
    return (c: FormControl): { [key: string]: boolean } | null => {
      const fieldValue = c.value;
      if (!fieldValue || fieldValue !== comparisonValue) {
        return {notMatch: true};
      }

      return null;
    };
  }

  static ValidPassword(): ValidatorFn {
    return (c: FormControl): { [key: string]: boolean } | null => {
      const fieldValue = c.value;
      const isValid = (fieldValue.length >= 8 && /[A-Z]/.test(fieldValue) && /[a-z]/.test(fieldValue) && /[0-9]/.test(fieldValue));

      return isValid ? undefined : {invalidPassword: true};
    };
  }

}
