import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'truncate'
})
export class TruncatePipe implements PipeTransform {

  transform(value, length): string {
    if (!value) {
      return '';
    }
    let newValue = '';
    if (value.length > length) {
      newValue = `${value.substring(0, length - 3)} ...`;
    }

    return newValue;
  }

}
