import { Directive, ElementRef, OnInit } from '@angular/core';

@Directive({
  selector: '[appPassword]'
})
export class PasswordDirective implements OnInit {

  private readonly element: HTMLInputElement;

  constructor(
    private elRef: ElementRef
  ) {
    this.element = elRef.nativeElement;
  }

  ngOnInit(): void {
    const img = document.createElement('img');
    img.classList.add('password-eye');
    img.src = '/assets/svgs/eye.svg';
    img.addEventListener('click', () => {
      const type = this.element.getAttribute('type');
      type === 'password' ?  this.element.setAttribute('type', 'text') : this.element.setAttribute('type', 'password');
    });
    setTimeout(() => {
      this.element.parentElement.appendChild(img);
      this.element.classList.add('password-field');
    }, 0);
  }

}
