import { HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { FormArray, FormControl, FormGroup } from '@angular/forms';
import { SHOW_ERRORS } from '../config';

@Injectable()

export class UtilsService {

  validateAllFormFields(formGroup?: FormGroup): void {
    Object
      .keys(formGroup.controls)
      .forEach(field => {
        const control = formGroup.get(field);
        if (control instanceof FormControl) {
          control.markAsDirty({ onlySelf: true });
        } else if (control instanceof FormGroup) {
          this.validateAllFormFields(control);
        } else if (control instanceof FormArray) {
          control.controls.forEach(ctrl => {
            if (ctrl instanceof FormControl) {
              ctrl.markAsDirty({ onlySelf: true });
            } else if (ctrl instanceof FormGroup) {
              this.validateAllFormFields(ctrl);
            }
          });
        }
      });
  }

  handleHttpError(error: HttpErrorResponse): any {
    switch (error.status) {
      case 401:
        if (SHOW_ERRORS.e401) {
          console.log(`Error ${error.status}`);
        }
        break;
      case 400:
        if (SHOW_ERRORS.e400) {
          console.log(`Error ${error.status}`);
        }
        break;
      case 500:
        if (SHOW_ERRORS.e500) {
          console.log(`Error ${error.status}`);
        }
        break;
      case 404:
        if (SHOW_ERRORS.e404) {
          console.log(`Error ${error.status}`);
        }
        break;
      case 422:
        if (SHOW_ERRORS.e422) {
          console.log(`Error ${error.status}`);
        }
        break;
      case 403:
        if (SHOW_ERRORS.e403) {
          console.log(`Error ${error.status}`);
        }
        break;
      default:
    }
  }
}
