import { Injectable } from '@angular/core';
import { SvgIconRegistryService } from 'angular-svg-icon';
import { forkJoin } from 'rxjs';
import { retry } from 'rxjs/operators';
import { ICONS } from '../../config/icon-list';

@Injectable()
export class IconsService {

  icons  = ICONS;

  constructor(
    private iconReg: SvgIconRegistryService
  ) {
  }

  async loadSvgIcons(): Promise<any> {
    return new Promise<any>(resolve => {
      forkJoin(this.icons.map(icon => this.iconReg.loadSvg(icon.url, icon.name).pipe(retry(3))))
        .subscribe(() => {
        resolve();
      });
    });
  }
}
