/* tslint:disable */
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { Subject } from 'rxjs';
import { map, share } from 'rxjs/operators';

@Injectable()

export class HttpService {

  private accessTokken: string;
  private headers;
  private api;
  private sendAuthMsg;
  private logoutNotification = new Subject();

  constructor(
    private http: HttpClient,
    private router: Router
  ) {
    this.sendAuthMsg = true;
  }

  setAPIURL(url) {
    this.api = url;
  }

  setTokken(value) {
    this.accessTokken = value;
  }

  getToken() {
    return this.accessTokken;
  }

  getAPIURL() {
    return this.api;
  }

  onLogout() {
    return this.logoutNotification.asObservable();
  }

  createHeader(extraHeaders = {}) {
    const headers = {
      'Content-Type': 'application/json', ...extraHeaders};
    if (extraHeaders['Content-Type'] === null) {
      delete headers['Content-Type'];
    }
    if (this.accessTokken) {
      headers[`Authorization`] = 'Bearer ' + this.accessTokken;
    }
    this.headers = new HttpHeaders(headers);
  }

  sendUnAuthorizedMessage(message) {
    message = message || 'You need to login first.';
    this.sendAuthMsg = false;
    // this.toastr.error(message, null, {showCloseButton: true});
    setTimeout(() => {
      this.sendAuthMsg = true;
    }, 5000);
    this.logoutNotification.next('user_logout');
  }

  mapResponse(resp, returnHeaders = false) {
    if (returnHeaders === false) {
      return resp.body;
    } else {
      return {
        body: resp.body,
        headers: resp.headers
      };
    }
  }

  get(method, value = '', showErrors = {}, returnHeaders = false, absoluteUrl = false, extraHeaders = {}) {
    this.createHeader(extraHeaders);
    const url = (absoluteUrl ? '' : this.api) + method + value;

    return this.http.get(url, {
      headers: this.headers,
      observe: 'response'
    }).pipe(map(resp => this.mapResponse(resp, returnHeaders)));
  }

  post(method, value, showErrors = {}, returnHeaders = false, absoluteUrl = false, extraHeaders = {}) {
    this.createHeader(extraHeaders);
    const url = (absoluteUrl ? '' : this.api) + method;

    return this.http.post(url, value, {
      headers: this.headers,
      observe: 'response'
    }).pipe(map(resp => this.mapResponse(resp, returnHeaders)));
  }

  put(method, value, showErrors = {}, returnHeaders = false) {
    this.createHeader();
    const url = this.api + method;

    return this.http.put(url, value, {
      headers: this.headers,
      observe: 'response'
    }).pipe(map(resp => this.mapResponse(resp, returnHeaders)));
  }

  delete(method, value = '', showErrors = {}, returnHeaders = false) {
    this.createHeader();
    const url = this.api + method + value;

    return this.http.delete(url, {
      headers: this.headers,
      observe: 'response'
    }).pipe(map(resp => this.mapResponse(resp, returnHeaders)));
  }
}
