import { Component, ContentChild, Input } from '@angular/core';
import { AbstractControl, FormControlName } from '@angular/forms';
import { CONFIG } from '../../config';
import { FocusBlurDirective } from '../../directives/focus-blur.directive';

@Component({
  selector: 'app-form-control',
  templateUrl: './form-control.component.pug'
})
export class FormControlComponent {

  @Input() errorMap;
  @Input() class = '';
  @ContentChild(FormControlName, {static: false}) fcn: FormControlName;
  @ContentChild(FocusBlurDirective, {static: false}) focusBlur: FocusBlurDirective;

  getError(): string {
    const errors = this.fcn.control.errors;
    let error = '';

    Object
      .keys(errors)
      .some(errorKey => {
        if (errors[errorKey]) {
          error = this.errorMap
            ? this.errorMap[errorKey]
              ? this.errorMap[errorKey]
              : CONFIG.errorMessages[errorKey]
            : CONFIG.errorMessages[errorKey];

          return true;
        }
      });

    return error;
  }

  get control(): AbstractControl {
    return this.fcn.control;
  }

  get isHighlighted(): boolean {
    return this.control.invalid && (this.control.dirty || this.control.touched);
  }

}
