import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { MessageTemplateModel } from '../../models/messageTemplateModel';
import { SorterModel } from '../../models/sorterModel';
import { BaseComponent } from '../base/base.component';

import { AppService } from '../../app.service';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { ListMessageTemplateService } from './list-message-template.service';

@Component({
  selector: 'app-list-message-template',
  templateUrl: './list-message-template.component.html',
  styleUrls: ['./list-message-template.component.scss']
})
export class ListMessageTemplateComponent extends BaseComponent implements OnInit {

  subscriptions: Array<Subscription> = [];
  myTemplates: Array<MessageTemplateModel> = [];
  sharedTemplates: Array<MessageTemplateModel> = [];
  sortOptions: Array<SorterModel>;
  sortSelected: SorterModel;
  showLoader = false;

  constructor(
    private router: Router,
    private activatedRoute: ActivatedRoute,
    private utilsService: UtilsService,
    private searchService: SearchService,
    private appService: AppService,
    private listMessageTemplateService: ListMessageTemplateService
  ) {
    super(utilsService);
  }

  ngOnInit(): void {
    this.sortOptions = [
      new SorterModel('Alphabetical (A-Z)', true),
      new SorterModel('Alphabetical (Z-A)', false)
    ];
    this.showLoader = true;
    const sharedMsgParams = {
      OnlyGlobalTemplate: true
    };
    const myMsgParams = {
      OnlyGlobalTemplate: false
    };
    this.subscriptions.push(
      this.listMessageTemplateService
        .getMessageTemplates(myMsgParams, [])
        .subscribe(
          messages => {
            this.myTemplates = messages;
          },
          error => {
            this.showLoader = false;
            this.utilsService.handleError(error);
          }
        )
    );
    this.subscriptions.push(
      this.listMessageTemplateService
        .getMessageTemplates(sharedMsgParams, [])
        .subscribe(
          messages => {
            this.sharedTemplates = messages;
          },
          error => {
            this.showLoader = false;
            this.utilsService.handleError(error);
          }
        )
    );
    setTimeout(() => (this.showLoader = false), 0);
  }

  sortMessageTemplates(): void {
    this.showLoader = true;
    this.myTemplates = this.utilsService.sort(this.myTemplates,
      ['TemplateName'], [this.sortSelected.ascending ? 1 : -1], false);
    this.sharedTemplates = this.utilsService.sort(this.sharedTemplates,
      ['TemplateName'], [this.sortSelected.ascending ? 1 : -1], false);
    this.showLoader = false;
  }

  onRowSelect(data: MessageTemplateModel): void {
    this.showLoader = true;
    this.router.navigate(['/edit-message-template', data.ObjectID]);
  }
}
