import { OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs';
import { UtilsService } from '../../oneit/services/utils.service';

export class BaseComponent implements OnDestroy {

  isLoading = false;
  subscriptions: Array<Subscription> = [];

  constructor(
    protected utilService: UtilsService
  ) {
  }

  ngOnDestroy(): void {
    this.utilService.unsubscribeSubscriptions(this.subscriptions);
  }

}
