<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "sign_up_eap_jsp"; } %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();
    Boolean             toRedirect  =   GenericObjDF.getOrCreateObject (request, "Company", Company.REFERENCE_Company);
    Company             company     =   (Company) process.getAttribute("Company");

    SecUser             secUser     =   null;
    CompanyUser         companyUser =   company.getAddedByUser(); 

    if(companyUser == null)
    {
        secUser     =   SecUser.createSecUser(objTran);
        companyUser =   secUser.getExtensionOrCreate(CompanyUser.REFERENCE_CompanyUser);

        company.setAddedByUser(companyUser);
        companyUser.setCompany(company);

        HiringTeam hiringTeam   =   company.getHiringTeamsAt(0);
        hiringTeam.setAddedByUser(companyUser);
        companyUser.setDefaultHiringTeam(hiringTeam);

        CompanyUserHiringTeamLink link  =   CompanyUserHiringTeamLink.createCompanyUserHiringTeamLink(objTran);
        link.setCompanyUser(companyUser);
        link.setHiringTeam(hiringTeam);
    }
    
    secUser     =   companyUser.getUser(); 
    
    if(toRedirect)
    {
        %><%@include file="/saferedirect.jsp"%><%
    }
    
    Debug.assertion(companyUser != null, "CompanyUser is null in admin portal");
%>

<script type="text/javascript">
    $(document).ready(function() {
        validate();
        $('input').on('change keyup', function() { validate() });
    });

    function validate() {
        var empty = false;
        $('input[required]').each(function() {
            if ( $.trim($( this ).val()) == '') {
                empty = true;
                if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                   empty = false;
                }
            }
        });

        if (empty) {
            $('.send-btn').attr('disabled', 'disabled');
        } else {
            $('.send-btn').removeAttr('disabled');
        }
    }
</script>
<style>
    button[disabled] {
        opacity: 0.6;
        background-color: #0582ba;
    }
</style>

<div class="hire-the-right-candi">Hire the right candidate</div>
<div>&nbsp;</div>

<oneit:form name="sign_up"    method="post">
    <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
    
    <div class="main-box-layout login-box">
        <oneit:dynInclude   page="/extensions/adminportal/inc/company_user_data.jsp"    data="<%= CollectionUtils.EMPTY_MAP%>"  CompanyUser="<%= companyUser %>"/>

        <oneit:button   value="Sign up"    name="send" cssClass="box-btn send-btn"
                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "verification_sent.jsp")
                                                        .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "emailSent")
                                                        .mapEntry("Company", company)
                                                        .toMap() %>"/>
    </div>
</oneit:form>
   
<%@ include file="inc/htmlfooter_nopriv.jsp" %>