import { Component, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { JobBaseComponent } from '../../../base/job-base.component';
import { PersonalDetailsComponent } from '../../../mc-shared/personal-details/personal-details.component';
import { JobService } from '../../../services/job.service';

@Component({
    selector: 'app-job-personal-details',
    templateUrl: './job-personal-details.component.html',
    styleUrls: ['./job-personal-details.component.scss']
})
export class JobPersonalDetailsComponent extends JobBaseComponent implements OnInit {

    applicantJobId;

    @ViewChild('personalDetailsComponent') personalDetailsComponent: PersonalDetailsComponent;

    constructor(
        activatedRoute: ActivatedRoute,
        jobService: JobService,
        utilsService: UtilsService
    ) {
        super(activatedRoute, jobService, utilsService);
    }

    jobLoaded(): void {
        console.log('JOB LOADED', this.applicantJob);
    }

    next(action: 'exit' | 'proceed'): void {
        const route = action === 'exit' ? '/my-career-web/jobs' : (this.completedView ? '/my-career-web/jobs' : `/my-career-web/jobs/${this.applicantJobId}/work-history`);
        this.isLoading = true;
        this.personalDetailsComponent.updateProfile(route);
    }

}
