import { ChangeDetectorRef, Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { environment } from '../../../../environments/environment';
import { BaseComponent } from '../../base/base.component';
import { CareerProfileModel } from '../../models/career-profile.model';
import { AuthService } from '../../services/auth.service';
import { HelperService } from '../../services/helper.service';
import { PersonalDetailsService } from '../../services/personal-details.service';

@Component({
    selector: 'app-dashboard',
    templateUrl: './dashboard.component.html',
    styleUrls: ['./dashboard.component.scss']
})
export class DashboardComponent extends BaseComponent implements OnInit {

    showMobileNav;
    careerProfile = new CareerProfileModel();
    unassumeLink  = `${environment.baseUrl}unassume_mc.jsp`;
    hideTaskBar = false;

    constructor(
        private authService: AuthService,
        private router: Router,
        private helperService: HelperService,
        private changeDetectorRef: ChangeDetectorRef,
        private personalDetailsService: PersonalDetailsService
    ) {
        super();
    }

    ngOnInit(): void {
        this.helperService.hideTaskBar$()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.hideTaskBar = response;
                this.changeDetectorRef.detectChanges();
            });
        this.personalDetailsService.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.careerProfile = response;
            });
    }

    goToPage(route): void {
        this.router.navigate([route]);
        this.showMobileNav = false;
    }

    logout(): void {
        this.isLoading = true;
        this.authService.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.router.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

}
