<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<oneit:dynIncluded>

<%
    String      nextPage    =   WebUtils.getSamePageInRenderMode(request, "InviteUsers");  
    Company     company     =   (Company) process.getAttribute("Company");
    Boolean     socialLogin =   CollectionUtils.equals(process.getAttribute("socialLogin"), Boolean.TRUE);
    
    Debug.assertion(company != null, "Invalid company user in admin portal");

    HiringTeam  hiringTeam  =   company.getDefaultHiringTeam();

    Debug.assertion(hiringTeam != null, "No Hiring Team added in admin portal");

    CompanyUser companyUser =   company.getAddedByUser();
    SecUser     secUser     =   companyUser.getUser();
    Integer     pageNumber  =   1;
    
    process.setAttribute("Company", company);
    process.setAttribute("socialLogin", socialLogin);

    company.setCompletedProfile(Boolean.TRUE);
%>
    <script type="text/javascript">
        $(document).ready(function()
        {
            $('input[type="text"][id$="Industry"]').blur(function(){
                if($(this).next().val() === ""){
                   $(this).val('');
                }
            });
            
            $('input[type="text"][id$="Industry"]').attr('placeholder','Please select an Industry');
        });
    </script>
<div class="hello-company-name">Hello, <%= secUser.getFirstName() %></div>

<div class="section-tab-view">
    
    <oneit:form name="companyProfile" method="post" enctype="multipart/form-data">
        
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        
        <oneit:dynInclude   page="/extensions/adminportal/inc/company_profile_tabs.jsp" TabNumber="1"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="section-page-area"  style="text-align: left">
            <div class="main-sc-section">
                <div class="form-group">
                    <label><oneit:label GUIName="What type of hiring team are you?" /></label>
                    <%
                        FormTag     jobForm     =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder =   jobForm.getFormBuilder();
                        String      optionKey   =   WebUtils.getInputKey(request, hiringTeam, HiringTeam.FIELD_HiringTeamType);
                        String      formValue   =   formBuilder.fieldValue (optionKey, hiringTeam.getHiringTeamType() == null ? "" : hiringTeam.getHiringTeamType().getName());

                        for(HiringTeamType hiringTeamType : HiringTeamType.getHiringTeamTypeArray())
                        {
                            boolean isSelected          =   CollectionUtils.equals(formValue, hiringTeamType.getName());
                            String  hiringTeamTypeId    =   String.valueOf(hiringTeam.getID().longID()) + "_hiringteamtype_" + hiringTeamType.getName();
                            String  selected            =   isSelected ? "checked" : "";
                            String  activeClass         =   isSelected ? "active" : "";
                    %>
                            <div    class="<%= "radio radio-primary workplace-radio " %>">
                                <input  type="radio"    name="<%= optionKey %>"    id="<%= hiringTeamTypeId %>"    class="element_rating_radio" value="<%= hiringTeamType.getName() %>" <%= selected %> >
                                <label  for="<%= hiringTeamTypeId %>">
                                    <oneit:toString value="<%= hiringTeamType %>"   mode="EscapeHTML"/>
                                </label>
                            </div>
                    <%
                        }
                    %>
                </div>

                <div class="form-group">
                    <label><oneit:label GUIName="Industry" /></label>
                    <oneit:ormEnum  obj="<%= hiringTeam %>" attributeName="Industry"    cssClass="form-control" displayType="autocomplete"/>
                </div>

                <div class="form-group">
                    <label><oneit:label GUIName="Time zone" /></label>
                    <oneit:ormEnum  obj="<%= hiringTeam %>" attributeName="TimeZone"    cssClass="form-control"/>
                </div>
            </div>

            <div class="text-center company-profile-btn">
                <oneit:button   value="Confirm details & invite teammates"  name="gotoPage"   cssClass="btn btn-primary box-btn"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage).toMap() %>"/>
            </div>
        </div>
        
    </oneit:form>
    
</div>

</oneit:dynIncluded>

<%@ include file="inc/htmlfooter_nopriv.jsp" %>