
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class EmailMessagePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea EmailMessagePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "EmailMessage");

    // Private attributes corresponding to business object data
    private String dummyMessageId;
    private String dummyEmailFrom;
    private String dummyEmailTo;
    private String dummyEmailCC;
    private String dummySubject;
    private String dummyDescription;
    private Date dummyReceivedDate;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_MessageId = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_EmailFrom = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_EmailTo = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_EmailCC = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Subject = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Description = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ReceivedDate = DefaultAttributeHelper.INSTANCE;
    



    public EmailMessagePersistenceMgr ()
    {
        dummyMessageId = (String)(HELPER_MessageId.initialise (dummyMessageId));
        dummyEmailFrom = (String)(HELPER_EmailFrom.initialise (dummyEmailFrom));
        dummyEmailTo = (String)(HELPER_EmailTo.initialise (dummyEmailTo));
        dummyEmailCC = (String)(HELPER_EmailCC.initialise (dummyEmailCC));
        dummySubject = (String)(HELPER_Subject.initialise (dummySubject));
        dummyDescription = (String)(HELPER_Description.initialise (dummyDescription));
        dummyReceivedDate = (Date)(HELPER_ReceivedDate.initialise (dummyReceivedDate));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_email_message.object_id as id, {PREFIX}tl_email_message.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_email_message.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_email_message.message_id, {PREFIX}tl_email_message.email_from, {PREFIX}tl_email_message.email_to, {PREFIX}tl_email_message.email_cc, {PREFIX}tl_email_message.subject, {PREFIX}tl_email_message.description, {PREFIX}tl_email_message.received_date, {PREFIX}tl_email_message.job_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, EmailMessage.REFERENCE_EmailMessage);

                if (objectToReturn instanceof EmailMessage)
                {
                    LogMgr.log (EmailMessagePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a EmailMessage");
                }
            }

            PersistentSet tl_email_messagePSet = allPSets.getPersistentSet(id, "tl_email_message", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_email_messagePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_MessageId)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_EmailFrom)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_EmailTo)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_EmailCC)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_Subject)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_Description)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.FIELD_ReceivedDate)||
                    !tl_email_messagePSet.containsAttrib(EmailMessage.SINGLEREFERENCE_Job))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (EmailMessagePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                EmailMessage result = new EmailMessage ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_email_message " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_email_message.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_email_messagePSet = allPSets.getPersistentSet(objectID, "tl_email_message");
            

            
            if (tl_email_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_email_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_email_message " +
                                                           "SET message_id = ?, email_from = ?, email_to = ?, email_cc = ?, subject = ?, description = ?, received_date = ?, job_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_email_message.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_MessageId.getForSQL(dummyMessageId, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_MessageId))).listEntry (HELPER_EmailFrom.getForSQL(dummyEmailFrom, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_EmailFrom))).listEntry (HELPER_EmailTo.getForSQL(dummyEmailTo, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_EmailTo))).listEntry (HELPER_EmailCC.getForSQL(dummyEmailCC, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_EmailCC))).listEntry (HELPER_Subject.getForSQL(dummySubject, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_Subject))).listEntry (HELPER_Description.getForSQL(dummyDescription, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_Description))).listEntry (HELPER_ReceivedDate.getForSQL(dummyReceivedDate, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_ReceivedDate))).listEntry (SQLManager.CheckNull((Long)(tl_email_messagePSet.getAttrib (EmailMessage.SINGLEREFERENCE_Job)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_email_message WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_email_message", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (EmailMessagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_email_message");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_email_message for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (EmailMessagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_email_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (EmailMessagePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_email_messagePSet = allPSets.getPersistentSet(objectID, "tl_email_message");
        

        LogMgr.log (EmailMessagePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_email_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_email_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_email_message " +
                                                       "WHERE tl_email_message.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_email_message WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_email_message");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_email_message for row:" + objectID;

                    LogMgr.log (EmailMessagePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_email_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, EmailMessage> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (EmailMessage.REFERENCE_EmailMessage.getObjectIDSpace (), r.getLong ("id"));
            EmailMessage resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, EmailMessage.REFERENCE_EmailMessage);

                if (cachedElement instanceof EmailMessage)
                {
                    LogMgr.log (EmailMessagePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (EmailMessage)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a EmailMessage");
                }
            }
            else
            {
                PersistentSet tl_email_messagePSet = allPSets.getPersistentSet(objectID, "tl_email_message", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new EmailMessage ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (EmailMessagePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_email_message " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (EmailMessage.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_email_message.object_id is not null
                    String preFilter = "(tl_email_message.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_email_message " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_email_messagePSet = allPSets.getPersistentSet(objectID, "tl_email_message", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_email_messagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_email_messagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_MessageId, HELPER_MessageId.getFromRS(dummyMessageId, r, "message_id"));
        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_EmailFrom, HELPER_EmailFrom.getFromRS(dummyEmailFrom, r, "email_from"));
        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_EmailTo, HELPER_EmailTo.getFromRS(dummyEmailTo, r, "email_to"));
        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_EmailCC, HELPER_EmailCC.getFromRS(dummyEmailCC, r, "email_cc"));
        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_Subject, HELPER_Subject.getFromRS(dummySubject, r, "subject"));
        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_Description, HELPER_Description.getFromRS(dummyDescription, r, "description"));
        tl_email_messagePSet.setAttrib(EmailMessage.FIELD_ReceivedDate, HELPER_ReceivedDate.getFromRS(dummyReceivedDate, r, "received_date"));
        
        tl_email_messagePSet.setAttrib(EmailMessage.SINGLEREFERENCE_Job, r.getObject ("job_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_email_messagePSet = allPSets.getPersistentSet(objectID, "tl_email_message");
        

        
        if (tl_email_messagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_email_messagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_email_message " +
                                     "  (message_id, email_from, email_to, email_cc, subject, description, received_date,  job_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_MessageId.getForSQL(dummyMessageId, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_MessageId))).listEntry (HELPER_EmailFrom.getForSQL(dummyEmailFrom, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_EmailFrom))).listEntry (HELPER_EmailTo.getForSQL(dummyEmailTo, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_EmailTo))).listEntry (HELPER_EmailCC.getForSQL(dummyEmailCC, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_EmailCC))).listEntry (HELPER_Subject.getForSQL(dummySubject, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_Subject))).listEntry (HELPER_Description.getForSQL(dummyDescription, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_Description))).listEntry (HELPER_ReceivedDate.getForSQL(dummyReceivedDate, tl_email_messagePSet.getAttrib (EmailMessage.FIELD_ReceivedDate))) .listEntry (SQLManager.CheckNull((Long)(tl_email_messagePSet.getAttrib (EmailMessage.SINGLEREFERENCE_Job)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_email_messagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
