import { MatricsReport } from './matrics-report.model';
import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { AppService } from '../../../app.service';
import { SaveService } from '../../../oneit/services/save.service';
import { UtilsService } from '../../../oneit/services/utils.service';
import { MatricsReportService } from './matrics-report.service';



@Component({
    selector: 'app-matrics-report',
    templateUrl: './matrics-report.component.html'
})
export class MatricsReportComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    report: MatricsReport;
    bos:    any[] = [];
    
    coupons: any[] = [];
    bosCols = [
        { field: 'Date', header: 'Date', width: '17%', noSort: false, noFilter: false},
        { field: 'NumberofCareerSeekers', header: 'Number of Career Seekers', width: '17%', noSort: false, noFilter: false},
        { field: 'NumberofPremiumCareerSeekers', header: 'Number of Premium Career Seekers', width: '17%', noSort: false, noFilter: false},
        { field: 'RenewalsDue', header: 'Renewals Due', width: '17%', noSort: false, noFilter: false},
        { field: 'SubscriptionRevenue', header: 'Subscription Revenue', width: '17%', noSort: false, noFilter: false},
        { field: 'OneOffRevenue', header: 'One-Off Revenue', width: '17%', noSort: false, noFilter: false}
    ];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private matricsReportService: MatricsReportService
    ){
        
    }

    ngOnInit() {
    }
    

    autoCompleteCoupon(event) {
        this.subscriptions.push(this.matricsReportService.getCouponsForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.coupons = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}