import { Component, Input, OnDestroy, OnInit, ViewChild, OnChanges, SimpleChange } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs';
import { UtilsService } from '../../../oneit/services/utils.service';
import { UserService } from '../../../oneit/services/user.service';
import { AuditTabService } from './audit-tab.service';

@Component({
    selector: 'app-audit-tab',
    templateUrl: './audit-tab.component.html',
    styleUrls: ['./audit-tab.component.scss'],
})
export class AuditTabComponent implements OnInit, OnDestroy, OnChanges  {

    subscriptions                           :   Array<Subscription>   =   [];
    @ViewChild('form')  form                :   NgForm;
    @Input()            BO                  :   any;
    @Input()            ShowAffectedObjects :   boolean = true;

    events                      :   any[]               =   [];
    showLoader                  :   boolean             =   false;
    reloadTextarea              :   boolean             =   false;
    showScrollToBottom          :   boolean             =   false;
    currentUserID               :   string;
    inProgress                  :   boolean             =   false;

    changeTablesCols    =   [
                                { field: 'Field', header: 'Field', width: '25%', noSort: true, noFilter: true},
                                { field: 'ChangeType.Description', header: 'Change Type', width: '25%', noSort: true, noFilter: true},
                                { field: 'OldValue', header: 'Old', width: '25%', noSort: true, noFilter: true},
                                { field: 'NewValue', header: 'New', width: '25%', noSort: true, noFilter: true},
                            ];

    constructor(
        private utilsService            :   UtilsService,
        private auditTabService         :   AuditTabService,
        private userService             :   UserService,
    ) {
    }

    ngOnInit() {
        this.currentUserID    =   this.userService.getUserid();
    }

    ngOnChanges(changes: {[propKey: string]: SimpleChange}) {
        for (let propName in changes) {
            if(propName == 'BO') {
                setTimeout(() => {
                    if (this.BO && this.BO.ObjectID) {
                        this.getEvents();
                    }
                }, 500);
            }
        }
    }

    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }

    private getEvents() {
        if (this.BO && this.BO.ObjectID) {
            this.subscriptions.push(
                this.auditTabService.getAuditEvents(this.BO, ['ChangeSet', 'ChangeSet.Changes','ChangeSet.AffectedScope',
                                                                'ChangeSet.AffectedScope.ChangeSet','DirectChangeSets', 'DirectChangeSets.Changes',
                                                                'ChangeSet.UnallocatedAffectedScopes','ChangeSet.UnallocatedAffectedScopes.ChangeSet'], this.ShowAffectedObjects)
                .subscribe(
                    data  => {
                        this.events    = data;
                    }, 
                    error => {
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
}
