import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SearchService } from './../../oneit/services/search.service';
import { SearchWorkflowTemplatesService } from './search-workflow-templates.service';

import { SearchWorkflowTemplate } from './search-workflow-templates.model';

@Component({
    selector: 'app-search-workflow-templates',
    templateUrl: './search-workflow-templates.component.html'
})
export class SearchWorkflowTemplatesComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    searchWorkflowTemplate : SearchWorkflowTemplate = new SearchWorkflowTemplate();
    workflowTemplates: any[] = [];
    showResults: boolean = false;
    s: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private appService: AppService,
        private searchWorkflowTemplatesService: SearchWorkflowTemplatesService
    ){
        
    }

    ngOnInit() {

        this.searchService.getLastSearchRequest("SearchWorkflowTemplate").subscribe(
            data => {
                if (data != null) {
                    this.searchWorkflowTemplate = data.queryParams;
                    this.getWorkflowTemplates(false);
                }
            }
        );
        this.gets();
    }
    

    gets() {
        this.subscriptions.push(this.searchWorkflowTemplatesService.getDummy48s([])
            .subscribe(
                data => {
                    this.s = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    getWorkflowTemplates(saveSearch: boolean) {
        
        this.showResults    =   true;
        this.showLoader     =   true;
        let assocs          =   [];
        
        this.subscriptions.push(this.searchWorkflowTemplatesService.getWorkflowTemplates(this.searchWorkflowTemplate, assocs, saveSearch)
            .subscribe(
                data => {
                    this.workflowTemplates = data;
                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
        
    onRowSelect(data) {
        this.router.navigate(['/XXXX', data.ObjectID]);
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}