import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { CheckboxModule } from 'primeng/checkbox';
import { RadioButtonModule } from 'primeng/radiobutton';
import { ToastModule } from 'primeng/toast';
import { HelperService } from '../services/helper.service';
import { ToasterService } from '../services/toaster.service';
import { FormControlComponent } from './form-control/form-control.component';
import { OverlayComponent } from './overlay/overlay.component';

const MODULES = [
    ReactiveFormsModule,
    FormsModule,
    RadioButtonModule,
    CheckboxModule,
    ToastModule
];

const COMPONENTS = [
    FormControlComponent,
    OverlayComponent
];

const DIRECTIVES = [
];

@NgModule({
    imports: [
        CommonModule,
        ...MODULES
    ],
    exports: [
        ...MODULES,
        ...COMPONENTS,
        ...DIRECTIVES
    ],
    providers: [
        ToasterService,
        HelperService
    ],
    declarations: [
        ...COMPONENTS,
        ...DIRECTIVES
    ]
})
export class McSharedModule {
}
