import { Injectable } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { EnumService } from '../../../oneit/services/enum.service';
import { SaveService } from '../../../oneit/services/save.service';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';
import { SERVICES } from '../config/constants';
import { CareerProfileModel } from '../models/career-profile.model';

@Injectable()

export class PersonalDetailsService {

    private _detailsUpdated = new Subject<CareerProfileModel>();

    get careerProfileUpdated$(): Observable<CareerProfileModel> {
        return this._detailsUpdated.asObservable();
    }

    set careerProfileUpdated(profile: CareerProfileModel) {
        this._detailsUpdated.next(profile);
    }

    constructor(
        private es: EnumService,
        private us: UtilsService,
        private ss: SearchService,
        private svs: SaveService
    ) {
    }

    getEmploymentStatuses(): Observable<any> {
        return this.es.getEnums('EmploymentStatuses', true);
    }

    getEmploymentPreferences(): Observable<any> {
        return this.es.getEnums('EmploymentPreferences', true);
    }

    getJobTitles(queryParams = {}, assocs = []): Observable<any> {
        return this.ss.getObjects(SERVICES.JOB_TITLES, 'All', queryParams, assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs);
                }
            )
    }

    getSkills(queryParams = {}, assocs = []): Observable<any> {
        return this.ss.getObjects(SERVICES.SKILLS, 'All', queryParams, assocs, null, null, null, null)
          .map(
            data => {
                return this.us.convertResponseToObjects(data, assocs);
            }
          )
    }

    getCertifications(queryParams = {}, assocs = []): Observable<any> {
        return this.ss.getObjects(SERVICES.CERTIFICATIONS, 'All', queryParams, assocs, 'Autocomplete', null, null, null)
          .map(
            data => {
                return this.us.convertResponseToObjects(data, assocs);
            }
          )
    }

    getSkillRatings(): Observable<any> {
        return this.es.getEnums('SkillRatings', true);
    }

    getCareerProfile(assocs = []): Observable<CareerProfileModel> {
        return this.ss.getObjects(SERVICES.CAREER_PROFILES, 'All', {}, assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs)[0];
                }
            )
    }

    saveProfile(createdObjs, updatedObjs, deletedObjs): Observable<any> {
        return this.svs.saveObjects('svc/SavePersonalDetails',createdObjs, updatedObjs, deletedObjs, true);
    }

}
