package performa.orm;

import java.util.*;
import oneit.logging.LoggingArea;
import oneit.objstore.rdbms.filters.InFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.utils.*;
import oneit.utils.filter.Filter;

public class TestInput extends BaseTestInput
{
    private static final long serialVersionUID = 0L;
    public  static final LoggingArea    LOG =   LoggingArea.createLoggingArea("TestAnalysis");
    
    // This constructor should not be called
    public TestInput ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    public List<Factor> getRelatedFactors()
    {
        Set<Factor>                 levelFactors    =   pipelineTestInput().toLevel().toFactors().toFactor().uniqueVals();
        Filter<FactorQuestionLink>  factorFilter    =   FactorQuestionLink.SearchByAll().andFactor(new InFilter(levelFactors));
        
        return ObjstoreUtils.sort(pipelineTestInput().toCandidates().toAnswers().toQuestion().toFactors(factorFilter).toFactor().uniqueVals(),
                                new ObjectTransform[]{Factor.pipesFactor().toDescription()},
                                new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR});
    }
}