import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { HelperService } from '../../services/helper.service';
import { AssessmentService } from '../../services/assessment.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';

@Component({
    selector: 'app-summary-report',
    templateUrl: './summary-report.component.html',
    styleUrls: ['./summary-report.component.scss']
})
export class SummaryReportComponent extends BaseComponent implements OnInit {

    showBody = false;
    reportChart = {
        role: {backgroundColor: '', backgroundImage: ''},
        culture: {backgroundColor: '', backgroundImage: ''}
    };

    constructor(
        private assessmentService: AssessmentService,
        private helperService: HelperService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit(): void {
        this.isLoading = true;
        this.assessmentService.getSummaryReport()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                console.log(response);
                this.isLoading = false;
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            });
    }

}
