
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class HTDiversityQuestionPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea HTDiversityQuestionPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "HTDiversityQuestion");

    // Private attributes corresponding to business object data
    private String dummyQuestionText;
    private Boolean dummyIsApplicable;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_QuestionText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsApplicable = DefaultAttributeHelper.INSTANCE;
    



    public HTDiversityQuestionPersistenceMgr ()
    {
        dummyQuestionText = (String)(HELPER_QuestionText.initialise (dummyQuestionText));
        dummyIsApplicable = (Boolean)(HELPER_IsApplicable.initialise (dummyIsApplicable));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_ht_diversity_question.object_id as id, {PREFIX}tl_ht_diversity_question.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_ht_diversity_question.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_ht_diversity_question.question_text, {PREFIX}tl_ht_diversity_question.is_applicable, {PREFIX}tl_ht_diversity_question.question_id, {PREFIX}tl_ht_diversity_question.hiring_team_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, HTDiversityQuestion.REFERENCE_HTDiversityQuestion);

                if (objectToReturn instanceof HTDiversityQuestion)
                {
                    LogMgr.log (HTDiversityQuestionPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a HTDiversityQuestion");
                }
            }

            PersistentSet tl_ht_diversity_questionPSet = allPSets.getPersistentSet(id, "tl_ht_diversity_question", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_ht_diversity_questionPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_ht_diversity_questionPSet.containsAttrib(HTDiversityQuestion.FIELD_QuestionText)||
                    !tl_ht_diversity_questionPSet.containsAttrib(HTDiversityQuestion.FIELD_IsApplicable)||
                    !tl_ht_diversity_questionPSet.containsAttrib(HTDiversityQuestion.SINGLEREFERENCE_Question)||
                    !tl_ht_diversity_questionPSet.containsAttrib(HTDiversityQuestion.SINGLEREFERENCE_HiringTeam))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (HTDiversityQuestionPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                HTDiversityQuestion result = new HTDiversityQuestion ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_ht_diversity_question " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_ht_diversity_question.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (HTDiversityQuestion.SINGLEREFERENCE_HiringTeam))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_ht_diversity_question " +
                            "WHERE " + SELECT_JOINS + "hiring_team_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_ht_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_ht_diversity_question");
            

            
            if (tl_ht_diversity_questionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_ht_diversity_questionPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_ht_diversity_question " +
                                                           "SET question_text = ?, is_applicable = ?, question_id = ? , hiring_team_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_ht_diversity_question.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_QuestionText.getForSQL(dummyQuestionText, tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.FIELD_QuestionText))).listEntry (HELPER_IsApplicable.getForSQL(dummyIsApplicable, tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.FIELD_IsApplicable))).listEntry (SQLManager.CheckNull((Long)(tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.SINGLEREFERENCE_Question)))).listEntry (SQLManager.CheckNull((Long)(tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.SINGLEREFERENCE_HiringTeam)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_ht_diversity_question WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_ht_diversity_question", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (HTDiversityQuestionPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_ht_diversity_question");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_ht_diversity_question for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (HTDiversityQuestionPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_ht_diversity_questionPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (HTDiversityQuestionPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_ht_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_ht_diversity_question");
        

        LogMgr.log (HTDiversityQuestionPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_ht_diversity_questionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_ht_diversity_questionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_ht_diversity_question " +
                                                       "WHERE tl_ht_diversity_question.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_ht_diversity_question WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_ht_diversity_question");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_ht_diversity_question for row:" + objectID;

                    LogMgr.log (HTDiversityQuestionPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_ht_diversity_questionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, HTDiversityQuestion> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (HTDiversityQuestion.REFERENCE_HTDiversityQuestion.getObjectIDSpace (), r.getLong ("id"));
            HTDiversityQuestion resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, HTDiversityQuestion.REFERENCE_HTDiversityQuestion);

                if (cachedElement instanceof HTDiversityQuestion)
                {
                    LogMgr.log (HTDiversityQuestionPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (HTDiversityQuestion)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a HTDiversityQuestion");
                }
            }
            else
            {
                PersistentSet tl_ht_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_ht_diversity_question", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new HTDiversityQuestion ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (HTDiversityQuestionPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_ht_diversity_question " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (HTDiversityQuestion.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_ht_diversity_question.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_ht_diversity_question.object_id is not null
                    String preFilter = "(tl_ht_diversity_question.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_ht_diversity_question " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_ht_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_ht_diversity_question", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_ht_diversity_questionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_ht_diversity_questionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_ht_diversity_questionPSet.setAttrib(HTDiversityQuestion.FIELD_QuestionText, HELPER_QuestionText.getFromRS(dummyQuestionText, r, "question_text"));
        tl_ht_diversity_questionPSet.setAttrib(HTDiversityQuestion.FIELD_IsApplicable, HELPER_IsApplicable.getFromRS(dummyIsApplicable, r, "is_applicable"));
        
        tl_ht_diversity_questionPSet.setAttrib(HTDiversityQuestion.SINGLEREFERENCE_Question, r.getObject ("question_id"));
        tl_ht_diversity_questionPSet.setAttrib(HTDiversityQuestion.SINGLEREFERENCE_HiringTeam, r.getObject ("hiring_team_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_ht_diversity_questionPSet = allPSets.getPersistentSet(objectID, "tl_ht_diversity_question");
        

        
        if (tl_ht_diversity_questionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_ht_diversity_questionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_ht_diversity_question " +
                                     "  (question_text, is_applicable,  question_id, hiring_team_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_QuestionText.getForSQL(dummyQuestionText, tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.FIELD_QuestionText))).listEntry (HELPER_IsApplicable.getForSQL(dummyIsApplicable, tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.FIELD_IsApplicable))) .listEntry (SQLManager.CheckNull((Long)(tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.SINGLEREFERENCE_Question)))).listEntry (SQLManager.CheckNull((Long)(tl_ht_diversity_questionPSet.getAttrib (HTDiversityQuestion.SINGLEREFERENCE_HiringTeam)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_ht_diversity_questionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
