package performa.batch;

import java.util.Calendar;
import oneit.appservices.batch.ORMBatch;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.rdbms.filters.InFilter;
import oneit.objstore.rdbms.filters.LessThanEqualFilter;
import oneit.utils.DateDiff;
import oneit.utils.parsers.FieldException;
import performa.orm.Job;
import performa.orm.types.JobStatus;


public class NotificationBatch extends ORMBatch
{
    public static LoggingArea NOTIFICATION_BATCH = LoggingArea.createLoggingArea("NotificationBatch");

    @Override
    public void run(ObjectTransaction ot) throws StorageException, FieldException
    {
        LogMgr.log (NOTIFICATION_BATCH, LogLevel.PROCESSING1, "RUNNING Notification Batch");

        Job[]   closedJobs      =   Job.SearchByAll()
                                        .andJobStatus(new InFilter<>(JobStatus.COMPLETE, JobStatus.FILLED))
                                        .andLastStatusChangeDate(new LessThanEqualFilter<>(DateDiff.add(DateDiff.getToday(), 14, Calendar.DATE)))
                                        .search(ot);
        
       
    }
}