
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class WorkFlowStagePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea WorkFlowStagePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "WorkFlowStage");

    // Private attributes corresponding to business object data
    private String dummyName;
    private Boolean dummyUseMessaging;
    private StageType dummyStageType;
    private Integer dummySortOrder;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Name = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_UseMessaging = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_StageType = new EnumeratedAttributeHelper (StageType.FACTORY_StageType);
    private static final DefaultAttributeHelper HELPER_SortOrder = DefaultAttributeHelper.INSTANCE;
    



    public WorkFlowStagePersistenceMgr ()
    {
        dummyName = (String)(HELPER_Name.initialise (dummyName));
        dummyUseMessaging = (Boolean)(HELPER_UseMessaging.initialise (dummyUseMessaging));
        dummyStageType = (StageType)(HELPER_StageType.initialise (dummyStageType));
        dummySortOrder = (Integer)(HELPER_SortOrder.initialise (dummySortOrder));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_work_flow_stage.object_id as id, {PREFIX}tl_work_flow_stage.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_work_flow_stage.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_work_flow_stage.name, {PREFIX}tl_work_flow_stage.use_messaging, {PREFIX}tl_work_flow_stage.stage_type, {PREFIX}tl_work_flow_stage.sort_order, {PREFIX}tl_work_flow_stage.withdrawal_message_id, {PREFIX}tl_work_flow_stage.work_flow_template_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, WorkFlowStage.REFERENCE_WorkFlowStage);

                if (objectToReturn instanceof WorkFlowStage)
                {
                    LogMgr.log (WorkFlowStagePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a WorkFlowStage");
                }
            }

            PersistentSet tl_work_flow_stagePSet = allPSets.getPersistentSet(id, "tl_work_flow_stage", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_work_flow_stagePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_work_flow_stagePSet.containsAttrib(WorkFlowStage.FIELD_Name)||
                    !tl_work_flow_stagePSet.containsAttrib(WorkFlowStage.FIELD_UseMessaging)||
                    !tl_work_flow_stagePSet.containsAttrib(WorkFlowStage.FIELD_StageType)||
                    !tl_work_flow_stagePSet.containsAttrib(WorkFlowStage.FIELD_SortOrder)||
                    !tl_work_flow_stagePSet.containsAttrib(WorkFlowStage.SINGLEREFERENCE_WithdrawalMessage)||
                    !tl_work_flow_stagePSet.containsAttrib(WorkFlowStage.SINGLEREFERENCE_WorkFlowTemplate))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (WorkFlowStagePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                WorkFlowStage result = new WorkFlowStage ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_work_flow_stage " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_work_flow_stage.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (WorkFlowStage.SINGLEREFERENCE_WorkFlowTemplate))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_work_flow_stage " +
                            "WHERE " + SELECT_JOINS + "work_flow_template_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_work_flow_stagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_stage");
            

            
            if (tl_work_flow_stagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_work_flow_stagePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_work_flow_stage " +
                                                           "SET name = ?, use_messaging = ?, stage_type = ?, sort_order = ?, withdrawal_message_id = ? , work_flow_template_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_work_flow_stage.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Name.getForSQL(dummyName, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_Name))).listEntry (HELPER_UseMessaging.getForSQL(dummyUseMessaging, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_UseMessaging))).listEntry (HELPER_StageType.getForSQL(dummyStageType, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_StageType))).listEntry (HELPER_SortOrder.getForSQL(dummySortOrder, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_SortOrder))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_stagePSet.getAttrib (WorkFlowStage.SINGLEREFERENCE_WithdrawalMessage)))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_stagePSet.getAttrib (WorkFlowStage.SINGLEREFERENCE_WorkFlowTemplate)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_work_flow_stage WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_work_flow_stage", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (WorkFlowStagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_work_flow_stage");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_work_flow_stage for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (WorkFlowStagePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_work_flow_stagePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (WorkFlowStagePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_work_flow_stagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_stage");
        

        LogMgr.log (WorkFlowStagePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_work_flow_stagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_work_flow_stagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_work_flow_stage " +
                                                       "WHERE tl_work_flow_stage.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_work_flow_stage WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_work_flow_stage");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_work_flow_stage for row:" + objectID;

                    LogMgr.log (WorkFlowStagePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_work_flow_stagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, WorkFlowStage> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (WorkFlowStage.REFERENCE_WorkFlowStage.getObjectIDSpace (), r.getLong ("id"));
            WorkFlowStage resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, WorkFlowStage.REFERENCE_WorkFlowStage);

                if (cachedElement instanceof WorkFlowStage)
                {
                    LogMgr.log (WorkFlowStagePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (WorkFlowStage)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a WorkFlowStage");
                }
            }
            else
            {
                PersistentSet tl_work_flow_stagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_stage", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new WorkFlowStage ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (WorkFlowStagePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_work_flow_stage " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (WorkFlowStage.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_work_flow_stage.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_work_flow_stage.object_id is not null
                    String preFilter = "(tl_work_flow_stage.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_work_flow_stage " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_work_flow_stagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_stage", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_work_flow_stagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_work_flow_stagePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_work_flow_stagePSet.setAttrib(WorkFlowStage.FIELD_Name, HELPER_Name.getFromRS(dummyName, r, "name"));
        tl_work_flow_stagePSet.setAttrib(WorkFlowStage.FIELD_UseMessaging, HELPER_UseMessaging.getFromRS(dummyUseMessaging, r, "use_messaging"));
        tl_work_flow_stagePSet.setAttrib(WorkFlowStage.FIELD_StageType, HELPER_StageType.getFromRS(dummyStageType, r, "stage_type"));
        tl_work_flow_stagePSet.setAttrib(WorkFlowStage.FIELD_SortOrder, HELPER_SortOrder.getFromRS(dummySortOrder, r, "sort_order"));
        
        tl_work_flow_stagePSet.setAttrib(WorkFlowStage.SINGLEREFERENCE_WithdrawalMessage, r.getObject ("withdrawal_message_id"));
        tl_work_flow_stagePSet.setAttrib(WorkFlowStage.SINGLEREFERENCE_WorkFlowTemplate, r.getObject ("work_flow_template_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_work_flow_stagePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_stage");
        

        
        if (tl_work_flow_stagePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_work_flow_stagePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_work_flow_stage " +
                                     "  (name, use_messaging, stage_type, sort_order,  withdrawal_message_id, work_flow_template_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Name.getForSQL(dummyName, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_Name))).listEntry (HELPER_UseMessaging.getForSQL(dummyUseMessaging, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_UseMessaging))).listEntry (HELPER_StageType.getForSQL(dummyStageType, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_StageType))).listEntry (HELPER_SortOrder.getForSQL(dummySortOrder, tl_work_flow_stagePSet.getAttrib (WorkFlowStage.FIELD_SortOrder))) .listEntry (SQLManager.CheckNull((Long)(tl_work_flow_stagePSet.getAttrib (WorkFlowStage.SINGLEREFERENCE_WithdrawalMessage)))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_stagePSet.getAttrib (WorkFlowStage.SINGLEREFERENCE_WorkFlowTemplate)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_work_flow_stagePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
