import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { MessageListApplicantViewLoginService } from './message-list-applicant-view-login.service';

import { ListApplicantViewLogin } from './message-list-applicant-view-login.model';

@Component({
    selector: 'app-message-list-applicant-view-login',
    templateUrl: './message-list-applicant-view-login.component.html'
})
export class MessageListApplicantViewLoginComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    listApplicantViewLogin = new ListApplicantViewLogin();
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private messageListApplicantViewLoginService: MessageListApplicantViewLoginService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getListApplicantViewLoginByID(params.id);
                    } else {
                        this.utilsService.createObject(this.listApplicantViewLogin, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
    }
    

    getListApplicantViewLoginByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.messageListApplicantViewLoginService.getListApplicantViewLoginByID(id, assocs)
            .subscribe(
                data => {
                    this.listApplicantViewLogin = data;
                    this.updatedObjs[this.listApplicantViewLogin.ObjectID] = this.listApplicantViewLogin;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    saveListApplicantViewLogin(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.listApplicantViewLogin.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/message-list-applicant-view-login", idToNavigate]);
                                return;
                            }
                            this.getListApplicantViewLoginByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}