<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>
<%@ page import="oneit.utils.filter.*"%>

<oneit:dynIncluded>
<%   
    Job job =   (Job) process.getAttribute("Job");

    if(job == null && request.getParameter("JobID") != null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    Debug.assertion(job != null, "Job is null in admin portal view applicants");
    
    SecUser                 secUser         =   SecUser.getTXUser(transaction);
    CompanyUser             companyUser     =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam              hiringTeam      =   companyUser.getSelectedTeam();

    if(hiringTeam != job.getHiringTeam())
    {
        response.sendRedirect(WebUtils.getArticleByShortCut(transaction, WebUtils.ADMIN_HOME).getLink(request));
    }

    String                  currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String                  applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    AppSortOption           appSortOpt      =   null;
    ApplicationFilter       appFilter       =   null;
    ApplicationStatus       workflowStatus  =   null;

    SearchApplicant         searchApplicant =   (SearchApplicant) RunSearchExecutorFP.setupExecutor(request, SearchApplicant.REFERENCE_SearchApplicant, true);
    JobApplication[]        applications    =   null;    
    Map<String, String[]>   parameterMap    =   request.getParameterMap();

    searchApplicant.setJob(job);

    if(applications == null)
    {
        applications    =   (JobApplication[]) searchApplicant.doSearch();
    }

    if (getData (request, GenericObjSearchDF.GENERIC_SEARCH_RESULTS) != null)
    {
        applications = (JobApplication[])getData (request, GenericObjSearchDF.GENERIC_SEARCH_RESULTS);
    }

    process.setAttribute("JobApplications", applications);

    // handle application sort option
    if( request.getParameter("AppSortOption") != null)
    {
        appSortOpt  =   AppSortOption.forName((String) request.getParameter("AppSortOption"));
    }
    else if(process.getAttribute("AppSortOption") != null)
    {
        appSortOpt  =   (AppSortOption) process.getAttribute("AppSortOption");
    }
    else
    {
        appSortOpt  =    AppSortOption.RANK;
    }

    // handle workflow status
    if(parameterMap.containsKey("WorkFlowStatus") && !request.getParameter("WorkFlowStatus").isEmpty())
    {
        workflowStatus  =   ApplicationStatus.forName((String) request.getParameter("WorkFlowStatus"));
    }
    else if(process.getAttribute("WorkFlowStatus") != null)
    {
        workflowStatus  =   (ApplicationStatus) process.getAttribute("WorkFlowStatus");
    }
    else
    {
        workflowStatus  =   ApplicationStatus.SUBMITTED;
    }

    boolean isApplicantPage =   workflowStatus == ApplicationStatus.SUBMITTED;
    boolean isDraftPage     =   workflowStatus == ApplicationStatus.DRAFT;

    // handle application filter (showing dropdown)
    if(parameterMap.containsKey("ApplicationFilter") && !request.getParameter("ApplicationFilter").isEmpty())
    {
        appFilter  =   ApplicationFilter.forName((String) request.getParameter("ApplicationFilter"));
    }
    else if(process.getAttribute("ApplicationFilter") != null)
    {
        appFilter  =   (ApplicationFilter) process.getAttribute("ApplicationFilter");
    }
    else
    {
        appFilter   =   ApplicationFilter.ALL_APPLICATIONS;
    }
                
    List<JobApplication>    applicantList   =   Arrays.asList(applications);
    WorkFlow                workflow        =   job.getWorkFlowByStatus(workflowStatus);

    // filter applicants by status
    oneit.utils.filter.Filter<JobApplication>  filter           =   JobApplication.SearchByAll().andApplicationStatus(new EqualsFilter<>(workflowStatus));
    oneit.utils.filter.Filter<JobApplication>  applicantFilter  =   JobApplication.SearchByAll().andApplicationStatus(new NotInFilter<>(ApplicationStatus.DRAFT, ApplicationStatus.POST_INGEST));
    oneit.utils.filter.Filter<JobApplication>  draftFilter      =   JobApplication.SearchByAll().andApplicationStatus(new InFilter<>(ApplicationStatus.DRAFT, ApplicationStatus.POST_INGEST));

    // if Applicant Status, then show all application completed applicants
    applicantList =   new ArrayList<>(CollectionFilter.filter(applicantList, isDraftPage ? draftFilter : (isApplicantPage ? applicantFilter : filter)));
    
    if(appFilter != ApplicationFilter.ALL_APPLICATIONS)
    {
        applicantList =   job.filterEssentialRequirements(appFilter == ApplicationFilter.HAS_REQ , applicantList);
    }

    if((process.getAttribute("ShowList") != null && process.getAttribute("ShowList") == Boolean.TRUE) || CollectionUtils.equals(workflowStatus,ApplicationStatus.DRAFT))
    {
        session.setAttribute("ShowList",true);
    }
    else if(process.getAttribute("ShowList") != null && process.getAttribute("ShowList") == Boolean.FALSE)
    {
        session.setAttribute("ShowList",false);
    }

    boolean                 showList        =   session.getAttribute("ShowList") != null ? (boolean) session.getAttribute("ShowList") : true;

    List<JobApplication>    sortedApplications  =   Utils.getApplicationsSorted(applicantList, appSortOpt);
    
    process.setAttribute("AppSortOption", appSortOpt);
    process.setAttribute("ApplicationFilter", appFilter);
    process.setAttribute("WorkFlowStatus", workflowStatus);
    process.setAttribute("ShowList", showList);
%>

    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">
        
        <div class="dashboard-content-area">
            <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  
                                ShowList="<%= showList %>"
                                applications="<%= sortedApplications %>"
                                WorkFlowStatus="<%= workflowStatus %>"   
                                WorkFlow="<%= workflow %>"   
                                data="<%= CollectionUtils.EMPTY_MAP%>"/>

            
            <div class="second-part view-app-area">
                <oneit:dynInclude   page="/extensions/adminportal/inc/application_sorting_bar.jsp"  
                                    ShowList="<%= showList %>"   
                                    SearchApplicant="<%= searchApplicant %>"   
                                    ShowOrderBy="<%= sortedApplications.size() > 1 %>"
                                    ApplicationFilter="<%= appFilter %>"
                                    WorkFlowStatus="<%= workflowStatus %>"
                                    SortOption="<%= appSortOpt %>"
                                    data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <%
                    if(showList)
                    {
                        if(workflowStatus == ApplicationStatus.DRAFT)
                        {
                %>
                            <oneit:dynInclude   page="/extensions/adminportal/inc/incomplete_applicants_list.jsp"  
                                                applications="<%= sortedApplications %>"
                                                currentPage="<%= currentPage %>"
                                                WorkFlowStatus="<%= workflowStatus %>"   
                                                data="<%= CollectionUtils.EMPTY_MAP%>"/>
                <%
                        }
                        else
                        {   
                %>
                            <oneit:dynInclude   page="/extensions/adminportal/inc/view_applicants_list.jsp"  
                                                applications="<%= sortedApplications %>"
                                                currentPage="<%= currentPage %>"
                                                WorkFlowStatus="<%= workflowStatus %>"   
                                                data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <%
                        }
                    }
                    else
                    {   
                        if(workflowStatus == ApplicationStatus.SHORTLISTED)
                        {
                %>
                            <oneit:dynInclude   page="/extensions/adminportal/inc/view_applicants_shortlist_grid.jsp"  
                                                applications="<%= sortedApplications %>"
                                                currentPage="<%= currentPage %>"
                                                data="<%= CollectionUtils.EMPTY_MAP%>"/>
                <%
                        }
                        else
                        {   
                %>
                            <oneit:dynInclude   page="/extensions/adminportal/inc/view_applicants_grid.jsp"  
                                                applications="<%= sortedApplications %>"
                                                currentPage="<%= currentPage %>"
                                                data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <%
                        }
                    }
                %>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>