<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran                 =   process.getTransaction ();
    String              currentPage             =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    String              nextPage                =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    JobApplication      jobApplication          =   (JobApplication) process.getAttribute("JobApplication");
    Job                 job                     =   jobApplication.getJob();
    Candidate           candidate               =   jobApplication.getCandidate();
    int                 cultureQuestionNo       =   process.getAttribute("CultureQuestionNo")!= null ? (int) process.getAttribute("CultureQuestionNo") : candidate.getCultureCriteriaAnswersCount();
    String              exitPage                =   WebUtils.getArticleLink(request, objTran, WebUtils.APPLY_JOB, "Page") + "&id=" + job.getID() + "&key=" + job.getRandomKey();
    boolean             toRedirect              =   jobApplication.createCultureCriteriaObjects();
    Boolean             isAssesmentComplete     =   jobApplication.assessmentCompleted();
    
    //to store current question number in history
    if(process.getAttribute("CultureQuestionNo")==null)
    {
        request.getSession().setAttribute ("historyQuestionNo", null);
    }
    
    if(request.getSession().getAttribute("historyQuestionNo")!=null && process.getAttribute("CultureQuestionNo")!= null)
    {
        if((int) process.getAttribute("CultureQuestionNo")<=(int) request.getSession().getAttribute("historyQuestionNo"))
        {
            cultureQuestionNo   =   (int) request.getSession().getAttribute("historyQuestionNo");
        }
    }
    
    if(isAssesmentComplete)
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    }
    
    if(toRedirect)
    {
        process.setAttribute("CultureQuestionNo", cultureQuestionNo);

        %><%@include file="/saferedirect.jsp" %><%
    }

    int                     total       =   candidate.getCultureCriteriaAnswersCount();
    boolean                 isLast      =   total == cultureQuestionNo + 1;
    
    if(isLast)
    {
        cultureQuestionNo   =   total -1;
    }

    CultureCriteriaAnswer   answer      =   candidate.getSortedCultureCriteriaAnswers().get(cultureQuestionNo);
    String                  numberText  =   (cultureQuestionNo + 1) + "/" + total;

    process.setAttribute("JobApplication", jobApplication);
    
    request.getSession().setAttribute ("historyQuestionNo", cultureQuestionNo);
%>
    <script>
        $(document.body).addClass('bg-color');
        
        $(document).ready(function()
        {
            $('.timer').countimer({
                displayMode: 1,
                initMinutes: 0,
                minuteIndicator: ' min ago',
                leadingZeros: 0
            });
        });
        
        function gotoNextQuestion()
        {
            setTimeout(
                function() {
                    $("#nextButton").click();
                },
            10); // delay in order to visually reinforce selection before advancing
        }
    </script>

    <div class="main-application-outline">
        <div class="selection-aust-logo">
        <%
            BinaryContent   logo    =   job.getLogo();

            if(logo != null)
            {
                int logoHeight  =   45;
        %>
                <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
        <%
            }
        %>
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
            <div class="clearfix no-height"></div>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Workplace Preferences</div>
            <div class="mobile-estimated">Estimated time to complete:
                <span class="estimated-time-20">&nbsp;5 mins</span>
            </div>
        </div>
        <div class="section-c-title m-hide">
            Workplace Preferences
            <span class="estimated-time">Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;5 mins</span>
            </span>
        </div>
        <div class="section-tab-view">

            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">

                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="2"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area">
                    <%
                        if(cultureQuestionNo == 0)
                        {
                    %>
                        <div class="main-sc-section">
                            <p>
                                A job isn't just about what one does, but the environment where one does it. 
                                This questionnaire will help us both learn what's most important to you in a workplace environment. 
                                There are no right or wrong answers, so please choose what best fits you (not what you think might be right for a particular job).
                            </p>
                        </div>
                        <div class="selection-br-line"></div>
                    <%
                        }
                    %>
                    <div class="main-sc-section main-wc-section">
                        <div class="rateing-title">
                            <span><oneit:toString value="<%= numberText %>"   mode="EscapeHTML"/></span>
                        </div>
                    <%
                        FormTag     applicationForm =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder     =   applicationForm.getFormBuilder();
                        
                        CultureCriteria                     criteria    = answer.getCriteriaJob(job);
                        Collection<CultureElementQuestion>  questions   = criteria.pipelineCultureCriteria().toCultureElement().toQuestions().vals();
                        String                              optionKey   = WebUtils.getRadioSingleAssocKey(request, answer, CultureCriteriaAnswer.SINGLEREFERENCE_SelectedQuestion);
                        String                              formValue   = formBuilder.fieldValue (optionKey, answer.getSelectedQuestion() == null ? "" : String.valueOf(answer.getSelectedQuestionID()));
                    %>
                        <div class="form-group-new wc-question-y-n">
                            <%
                                for(CultureElementQuestion question : questions)
                                {
                                    String  questionId  = String.valueOf(question.getID().longID());
                                    String  selectedStr = (CollectionUtils.equals(questionId, formValue) ? "checked" : "");
                            %>
                                    <div class="radio radio-primary second-radio-primary full-width">
                                        <input type="radio" name="<%= optionKey %>" id="<%= questionId %>"  class="element_rating_radio"  value="<%= questionId %>" <%= selectedStr %>  onchange="<%= !isLast ? "gotoNextQuestion();": "return false;"%>">
                                        <label for="<%= questionId %>">
                                            <oneit:toString value="<%= question.getDescription() %>"    mode="EscapeHTML"   nullValue="-"/>
                                        </label>
                                    </div>
                            <%
                                }
                            %>
                        </div>
                        
                        <div class="auto-save">
                            Autosaved <span class="timer"></span> 
                        </div>   
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section-bottom btn-remove-padd">
                        <div class="section-btn text-center">
                            <%
                                if(cultureQuestionNo < total)
                                {
                                    Set<String> attribsToRestore    = new HashSet<String> ();
                                    
                                    attribsToRestore.add ("CultureQuestionNo");
                                    attribsToRestore.add ("JobApplication");
                                    
                                    process.setAttribute("CultureQuestionNo", (cultureQuestionNo + 1));
                            %>
                                    <oneit:button   value=" "    name="saveAndExitCulture"  id="nextButton"    skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("CultureQuestionNo", (cultureQuestionNo + 1))
                                                                                                                            .mapEntry("JobApplication", jobApplication).toMap())
                                                                                    .mapEntry("attribNamesToRestore", attribsToRestore)
                                                                                    .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                    .toMap() %>"/>
                            <%
                                }
                            %>
                            <oneit:button   value="Save and exit"   name="saveAndExitCulture"   cssClass="<%= (!isLast) ? "box-btn-gray" : "box-btn-gray half-btn" %>"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", exitPage)
                                                                            .mapEntry ("JobApplication", jobApplication)
                                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                            .toMap() %>"/>
                            <%
                                if(isLast && isAssesmentComplete)
                                {
                            %>
                                    <oneit:button   value="Complete"    name="completeApplication"  id="nextButton"  cssClass="box-btn"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                        .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                        .toMap() %>"/>
                            <%
                                }
                                else if(isLast)
                                {
                            %>
                                    <oneit:button   value="Proceed to next step"    name="saveAndExitCulture" cssClass="box-btn m-hide"   id="gotoPage"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                        .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                        .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                        .toMap() %>"/>
                                    <oneit:button   value="Proceed"    name="saveAndExitCulture" cssClass="box-btn show-mobile"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                        .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                        .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                                        .toMap() %>"/>
                            <%
                                }
                            %>
                        </div>
                    </div>
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>