import {LoginPage} from "./pages/login.po";
import {Credentials} from "../protractor.conf";
import { CustomersPage } from "./pages/customers.po";
import { AdminHomePage } from "./pages/adminHome.po";
import { browser } from "protractor";
import { CreateJobPage } from "./pages/createjob.po";
import { async } from "q";

let loginPage:LoginPage;
let customersPage:CustomersPage;
let adminPage:AdminHomePage;
let createJobPage:CreateJobPage;
describe("Customers",()=>{

    beforeAll(() => {
        loginPage = new LoginPage();
    });

    it("Login user",async ()=>{
        await loginPage.navigateToLogin();
        await loginPage.setUsername(Credentials.username);
        await loginPage.setPassword(Credentials.password);
        customersPage = await loginPage.clickOnLoginButton();

    });

    it("Login to a customer",async()=>{
        adminPage = await customersPage.loginAsAdmin("Lone Star Gold");
        // await browser.sleep(5000);
    });

    it("Clicking Create Job button should show 'Create a new Job' option selected",async ()=>{
        // adminPage = new AdminHomePage();
        await browser.sleep(1000);
        createJobPage = await adminPage.clickCreateJobBtn();
       
        // createJobPage = new CreateJobPage();
        let jobOption:string = await createJobPage.getSelectedJobOption();
        expect(jobOption).toBe("Create a new job");
    });

    it("Clicking on 'Get Started' button should load Job Detail tab",async ()=>{
        await createJobPage.clickGetStartedBtn();
        let selectedTabText = await createJobPage.getSelectedTabName();
        expect(selectedTabText).toContain("Job Detail");
    });

    it("Job Detail page should have 'Job Title','Abot the Job' and 'ILO Standard Job Title' ans mandatory fields",async ()=>{
        await createJobPage.clickProceedToRequirementsBtn();
        let errorsList = await createJobPage.getErrorMessages();
        console.log(errorsList.toString());
        expect(errorsList.toString()).toBe("Errors occurred, please correct them and try again,Please enter a value for Job Title,Please enter a value for Job Description,Please enter a value for ILO Standard Job Title");
    });

});