import { Observable } from 'rxjs/Observable';
import { Injectable } from '@angular/core';

import { SearchService } from './../../oneit/services/search.service';
import { UtilsService } from './../../oneit/services/utils.service';

@Injectable()
export class ConfirmEditService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getMessageTemplateTypes(assocs): Observable<any> {
        return this.searchService.getObjects("", "All", {}, assocs, null, null, null, null)
                .map(
                    data => {
                        return this.utilsService.convertResponseToObjects(data, assocs);
                    }
                );
    }
    
}