import { Injectable } from '@angular/core';
import { EnumService } from '../../../oneit/services/enum.service';
import { Observable, Subject } from 'rxjs';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';
import { SaveService } from '../../../oneit/services/save.service';
import { SERVICES } from '../config/constants';
import { CareerProfileModel } from '../models/career-profile.model';

@Injectable()

export class PersonalDetailsService {

    private _detailsUpdated = new Subject<CareerProfileModel>();

    get careerProfileUpdated$(): Observable<CareerProfileModel> {
        return this._detailsUpdated.asObservable();
    }

    set careerProfileUpdated(profile: CareerProfileModel) {
        this._detailsUpdated.next(profile);
    }

    constructor(
        private es: EnumService,
        private us: UtilsService,
        private ss: SearchService,
        private svs: SaveService
    ) {
    }

    getEmploymentStatuses(): Observable<any> {
        return this.es.getEnums('EmploymentStatuses', true);
    }

    getEmploymentPreferences(): Observable<any> {
        return this.es.getEnums('EmploymentPreferences', true);
    }

    getJobTitles(queryParams = {}, assocs = []): Observable<any> {
        return this.ss.getObjects(SERVICES.JOB_TITLES, 'All', queryParams, assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs);
                }
            )
    }

    getCareerProfile(assocs = []): Observable<CareerProfileModel> {
        return this.ss.getObjects(SERVICES.CAREER_PROFILES, 'All', {}, assocs, null, null, null, null)
            .map(
                data => {
                    return this.us.convertResponseToObjects(data, assocs)[0];
                }
            )
    }

    saveProfile(createdObjs, updatedObjs, deletedObjs): Observable<any> {
        return this.svs.saveObjectsWithDefaultSvc(createdObjs, updatedObjs, deletedObjs, true);
    }

}
