import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { GlobalHiringTeamListMessageTemplatesService } from './global-hiring-team-list-message-templates.service';


@Component({
    selector: 'app-global-hiring-team-list-message-templates',
    templateUrl: './global-hiring-team-list-message-templates.component.html'
})
export class GlobalHiringTeamListMessageTemplatesComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    orders: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private globalHiringTeamListMessageTemplatesService: GlobalHiringTeamListMessageTemplatesService
    ){
        
    }

    ngOnInit() {

        this.getOrders();
    }
    

    getOrders() {
        this.subscriptions.push(this.globalHiringTeamListMessageTemplatesService.getorders([])
            .subscribe(
                data => {
                    this.orders = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}