package performa.batch;

import oneit.appservices.batch.ORMBatch;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.rdbms.filters.IsNullFilter;
import oneit.utils.parsers.FieldException;
import performa.orm.Job;


public class URLShortnerBatch   extends ORMBatch
{
    public static LoggingArea URL_SHORTNER_BATCH = LoggingArea.createLoggingArea("URLShortnerBatch");

    @Override
    public void run(ObjectTransaction ot) throws StorageException, FieldException
    {
        LogMgr.log (URL_SHORTNER_BATCH, LogLevel.DEBUG2, "RUNNING URL Shortner Batch");

        Job[]   jobs    =   Job.SearchByAll()
                                .andShortenedURL(new IsNullFilter<>())
                                .search(ot);
        
        for (Job job : jobs)
        {
            try
            {
                job.createShortenedURL();

                LogMgr.log(URL_SHORTNER_BATCH, LogLevel.DEBUG2, "Setting Shortened URL to job : ", job);
            }
            catch(StorageException | FieldException e)
            {
                LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while setting shortened URL to job : " + job);
            }
        }
    }
}