package performa.orm;

import java.util.Set;
import oneit.logging.LoggingArea;
import oneit.objstore.ValidationContext;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.StringUtils;
import oneit.utils.filter.Filter;


public class HiringTeam extends BaseHiringTeam
{
    private static final long serialVersionUID = 0L;
    
    public  static LoggingArea  LOG = LoggingArea.createLoggingArea("HiringTeam");

    // This constructor should not be called
    public HiringTeam ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    public boolean showHasClientSupport()
    {
        return isTrue(getHasClientSupport());
    }
    
    @Override
    public void validate(ValidationContext context) 
    {
//        if(getStatus() != ObjectStatus.NEW)
//        {
//            context.check(getHiringTeamType() != null , this, FIELD_HiringTeamType, "mandatory");
//        }
        
        super.validate(context);
    }
        
    @Override
    public String getToString() 
    {
        return StringUtils.subNulls(getHiringTeamName(), super.getToString());
    }
    
    public Set<CompanyUser> getActiveTeammates()
    {
        Filter<CompanyUser> filter  =   CompanyUser.SearchByAll()
                                                    .andIsAccountVerified(new EqualsFilter<>(Boolean.TRUE))
                                                    .andIsDisabled(new EqualsFilter<>(Boolean.FALSE));
        
        return CompanyUserHiringTeamLink.pipesCompanyUserHiringTeamLink(getUsersSet()).toCompanyUser(filter).uniqueVals();
    }
    
    public boolean isPPJ()
    {
        return isTrue(getIsPPJ());
    }
}