<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String              currentPage     =   WebUtils.getSamePageInRenderMode(request, "CoverLetter");
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    ObjectTransaction   objTran         =   process.getTransaction ();
    boolean             toRedirect      =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job                 job             =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");
    
    SecUser             secUser         =   SecUser.getTXUser(transaction);
    Candidate           candidate       =   secUser.getExtension(Candidate.REFERENCE_Candidate);
    
    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");
    
    JobApplication      jobApplication  =   JobApplication.searchCandidateJob(objTran, candidate, job);

    Debug.assertion(jobApplication != null, "Invalid Job Application in applicant portal");

    if(process.getAttribute("JobApplicationID") == null)
    {
        process.setAttribute("JobApplicationID" , jobApplication.getID().longValue());
    }

    process.setAttribute("JobApplication" , jobApplication);
%>
<script type="text/javascript">
        $(document.body).addClass('bg-color');
        
        $(document).ready(function(){
            $('.attach-icon-btn').click(function(){
               $(this).parent().find("input").click(); 
            });
            
            $("input:file").change(function (){
                var fullPath = $(this).val();
                var filename = fullPath.replace(/^.*[\\\/]/, '');
                $(this).parents(".form-control").append(filename);
            });
        });
</script>
 
<style>
    .main-verify-identity .second-style {
        font-size: 14px;
        line-height: 40px;
    }
</style>
        
    <div class="apply-job-logo-header signinpage">
        <div>
            <div class="logo-img">
            <%
                BinaryContent   logo    =   job.getLogo();

                if(logo != null)
                {
                    int logoHeight  =   45;
            %>
                    <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
            <%
                }
            %>
            </div>
            <div class="header-title">
                <%= job.getTeamName() %>
            </div>
        </div>
    </div>
    <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="main-verify-identity">
            <div class="pl-confirm text-center">
                Great! Now let's attach your CV and Cover Letter<br/><br/>
                Uploading your files in PDF format is strongly recommended</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left relative-parent ">
                    <label>Upload your CV</label>
                    <div class="form-control second-style">
                    <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CV"          cssClass="hide"/>
                    <div class="attach-icon-btn"></div>
                    </div>
                </div>
                <div class="form-group text-left relative-parent">
                    <label>Upload your Cover Letter</label>
                     <div class="form-control second-style">
                    <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CoverLetter" cssClass="hide"/>
                     <div class="attach-icon-btn"></div>
                      </div>
                </div>

                <div class="text-center">
                    <oneit:button   value="Attach and proceed"    name="validateApplication"   cssClass="box-btn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("fromCoverLetter", true)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .toMap() %>"/>
                </div>
            </div>
        </div>
    </oneit:form>
    
</oneit:dynIncluded>