import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AdminIframePageComponent } from './components/admin-portal/admin-iframe-page/admin-iframe-page.component';
import { AdminPortalLayoutComponent } from './components/admin-portal/admin-portal-layout/admin-portal-layout.component';
import { EditMessageTemplateComponent } from './components/admin-portal/edit-message-template/edit-message-template.component';
import { EditWorkflowTemplateComponent } from './components/admin-portal/edit-workflow-template/edit-workflow-template.component';
import { ListMessageTemplateComponent } from './components/admin-portal/list-message-template/list-message-template.component';
import { ListWorkFlowsComponent } from './components/admin-portal/list-work-flows/list-work-flows.component';
import { ApplicantPortalLayoutComponent } from './components/applicant-portal/applicant-portal-layout/applicant-portal-layout.component';
import { MessageEngineApplicantViewComponent } from './components/message-engine-applicant-view/message-engine-applicant-view.component';
import { AccessDeniedComponent } from './oneit/components/access-denied/access-denied.component';
import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { HomeComponent } from './oneit/components/home/home.component';
import { IframePageComponent } from './oneit/components/iframe-page/iframe-page.component';
import { AuthGuard } from './oneit/guards/auth.guard';

export const routes: Routes = [
    {
        path: '',
        redirectTo: 'home',
        pathMatch: 'full'
    },
    {
        path: '',
        component: FullLayoutComponent,
        data: {
            showDefaultHeader: true,
            showDefaultFooter: true,
            showMenu: true,
            showFeedback: true
        },
        children: [
            {
                path: 'access-denied',
                component: AccessDeniedComponent
            },
            {
                path: 'home',
                canActivate: [AuthGuard],
                component: HomeComponent
            },
            {
                path: 'iframe-page/:url',
                canActivate: [AuthGuard],
                component: IframePageComponent,
                runGuardsAndResolvers: 'always'
            },
            {
                path: 'list-message-templates/:global',
                component: ListMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-message-template/:global',
                component: EditMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-message-template/:global/:id',
                component: EditMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'list-workflow-templates/:global',
                component: ListWorkFlowsComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-workflow-template/:global',
                component: EditWorkflowTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-workflow-template/:global/:id',
                component: EditWorkflowTemplateComponent,
                canActivate: [AuthGuard]
            }
        ]
    },
    {
        path: 'admin',
        component: AdminPortalLayoutComponent,
        canActivate: [AuthGuard],
        data: {
            privs: ['TL_AccessAdminPortal'],
            redirectPage: 'extensions/adminportal/sign_in.jsp'
        },
        children: [
            {
                path: 'iframe-page/:url',
                component: AdminIframePageComponent,
                runGuardsAndResolvers: 'always'
            },
            {
                path: 'edit-message-template',
                component: EditMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-message-template/:id',
                component: EditMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'list-message-templates',
                component: ListMessageTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'list-workflow-templates',
                component: ListWorkFlowsComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-workflow-template',
                component: EditWorkflowTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'edit-workflow-template/:id',
                component: EditWorkflowTemplateComponent,
                canActivate: [AuthGuard]
            },
            {
                path: 'message-engine',
                component: MessageEngineApplicantViewComponent
            }
        ]
    },
    {
        path: 'applicant/:job',
        component: ApplicantPortalLayoutComponent,
        canActivate: [AuthGuard],
        data: {
            privs: ['TL_AccessApplicantPortal'],
            redirectPage: 'ApplicantPortal-ApplyJob.htm'
        },
        children: [
            {
                path: 'home',
                component: HomeComponent
            },
            {
                path: 'message-engine',
                component: MessageEngineApplicantViewComponent
            }
        ]
    }
];

@NgModule({
    imports: [RouterModule.forRoot(routes, {useHash: true, onSameUrlNavigation: 'reload'})],
    exports: [RouterModule]
})
export class AppRoutingModule {
}
