<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    JobApplication          jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    List<JobApplication>    applications    =   (List<JobApplication>) process.getAttribute("Applications");
    Long                    prevAppID       =   (Long) getData(request, "prevAppID");
    Long                    nextAppID       =   (Long) getData(request, "nextAppID");
    Job                     job             =   jobApplication.getJob();
    Candidate               candidate       =   jobApplication.getCandidate();
    String                  tabText         =   candidate.getToString();
    String                  currentPage     =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    
    Map<FactorClass, Tuple.T2<Double, ColorCode>>   roleScoreMap    =   (Map<FactorClass, Tuple.T2<Double, ColorCode>>)jobApplication.getRoleFit();
%>
<script>
    function tabToggle(tab, selectDiv) {
        $(".thr-block").each(function() {
            $(this).css("margin-top", 0);
            $(this).css("padding-top", 0);
            $(this).css("background-color", "#f7f7f8");
            $(this).parent().find(".progress-label").css("font-size", "12px");
        });
        
        $(selectDiv).css("margin-top", -10);
        $(selectDiv).css("padding-top", "5px")
        $(selectDiv).css("background", "#fff");
        $(selectDiv).find(":first").css("font-size", "16px");

        $(".nav-justified li").each(function() {
            $(this).removeClass('active');
        });

        $(tab).addClass('active');
    }
    
    function focusDiv(selectDiv) {
        var $el =   $(selectDiv).closest('.main-pro-bar').children('.pro-bar');
        
        if(!$el.hasClass('hasarrow'))
        {
            $el.click();
        }
        $(window).scrollTop($(selectDiv).offset().top);
    }
    
    function focusReqDiv(selectDiv) {
        var $el =   $(selectDiv).children('.pro-bar');
        
        if(!$el.hasClass('hasarrow'))
        {
            $el.click();
        }
        $(window).scrollTop($(selectDiv).offset().top);
    }
    
    $(document).ready(function() 
    {   
        $('.pro-bar').click(function() {
            var $el = $(this);  
            if($(this).hasClass('hasarrow')){
                $el.find('img').attr('src','images/select-down-arrow.svg');
                $(this).removeClass('hasarrow');
            }
            else{
                $el.find('img').attr('src','images/select-top-arrow.svg');
                $(this).addClass('hasarrow');
                
            }    
        });
        
        tabToggle("#tab1", ".role-fit");
    });
</script>
<div class="main-applicant-content dashboard-content-area v-applicant-area ">
    <div class="applicant-header">
        <oneit:button   name="gotoPage" value=" "   cssClass="prev-btn" skin="link"
                        requestAttribs="<%= CollectionUtils.mapEntry("procParams", CollectionUtils.mapEntry("Applications", applications).toMap())
                                                        .mapEntry("nextPage", currentPage+"&JobApplicationID="+prevAppID ).toMap() %>" >
            <img src="images/arrow-left-prev.svg" />
        </oneit:button>
        <div class="main-appli-name">
            <div class="appli-name"><oneit:toString value="<%= candidate.getToString() %>"  mode="EscapeHTML"/></div>
            <div class="appli-applied">
                Applied <oneit:toString  value="<%= jobApplication.getSubmittedDate() %>"   mode="MidDate"/>
            </div>
        </div>
        <div class="main-export">
            <span class="export-candidate"  style="display: none;">
                <select class="form-control">
                    <option>Export Candidate Report</option>
                    <option>PDF</option>
                    <option>Excel</option>
                </select>
            </span>
            <span class="appli-status-short">
                <oneit:ormEnum  obj="<%= jobApplication %>" onChange="$('#saveBtn').click()"  attributeName="ApplicationStatus"   cssClass="form-control status-img"
                                enums="<%= jobApplication.getAvailableStatuses() %>"/>
                <oneit:button   name="save" value="Save"    cssClass="hidden"   id="saveBtn"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "JobApplication"})))
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Job", job).toMap())
                                                                .mapEntry ("restartProcess", Boolean.TRUE).toMap() %>" />
            </span>
        </div>
        <oneit:button   name="gotoPage" value=" "   cssClass="next-btn" skin="link"
                        requestAttribs="<%= CollectionUtils.mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Applications", applications).toMap())
                                                        .mapEntry("nextPage", currentPage+"&JobApplicationID="+nextAppID ).toMap() %>" >
            <img src="images/arrow-right-next.svg" />
        </oneit:button>
    </div>
    <div class="main-applicant-content"> 
        <div class="applicant-sub-part">
            <div class="applicant-left">
                <%
                    Tuple.T2<Double, ColorCode> roleFitData     =   (jobApplication.getRoleFit()!=null && jobApplication.getRoleFit().get(null)!=null) ? (Tuple.T2<Double, ColorCode>) jobApplication.getRoleFit().get(null) : null;
                    String                      colorClass      =   "percent-" +(roleFitData!=null ? roleFitData.get1().getCSSClass() : "green");
                    List<FactorScore>           factorScores    =   jobApplication.getRoleAreaOfConcerns();
                    List<Tuple.T2>              cultureConcerns =   jobApplication.getCultureAreaOfConcerns();
                %>
                <div class="applicant-progress">
                    <div class="<%= job.getIncludeAssessmentCriteria()==Boolean.TRUE ? "col-sm-4" : "col-sm-6" %> col-xs-12 text-center thr-block role-fit" href="#1a" data-toggle="tab"    id="progress1"  onClick="tabToggle('#tab1', '.role-fit')">
                        <label class="progress-label">role fit</label>
                        <div class="<%= colorClass %> fixed-width">
                            <p style="display:none;"><oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"   mode="TwoDPDouble"  nullValue="0"/></p>
                        </div>
                        <div class="row four-label">
                        <%
                            if(!factorScores.isEmpty())
                            {
                                int rowCount    =   (factorScores.size() % 2 == 0) ? (factorScores.size() / 2) : ((factorScores.size() + 1) / 2);
                                
                                for(int i = 0; i < rowCount; i++)
                                {
                                    FactorScore firstScore  =   factorScores.get(i*2);
                                    FactorScore secondScore =   (factorScores.size() > ((i*2) + 1)) ? factorScores.get((i*2) + 1) : null;
                                    
                                    String      dotClass    =   firstScore.getColorCode() != null ? firstScore.getColorCode().getDotCSSClass() : "";
                        %>
                                    <div class="a-label-row">
                                        <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + firstScore.getObjectID() %>')">
                                            <span class="common-dot <%= dotClass %>"></span>
                                            <span class="r-y-label text-dot-dot">
                                                <oneit:toString value="<%= firstScore.getFactor() %>"   mode="EscapeHTML"/>
                                            </span>
                                        </div>
                                    <%
                                        if(secondScore != null)
                                        {
                                            dotClass    =   secondScore.getColorCode() != null ? secondScore.getColorCode().getDotCSSClass() : "";
                                    %>
                                            <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + secondScore.getObjectID() %>')">
                                                <span class="common-dot <%= dotClass %>"></span>
                                                <span class="r-y-label text-dot-dot">
                                                    <oneit:toString value="<%= secondScore.getFactor() %>"  mode="EscapeHTML"/>
                                                </span>
                                            </div>
                                    <%
                                        }
                                    %>
                                    </div>
                        <%
                                }
                            }
                        %>
                        </div>
                    </div>
                    <div class="<%= job.getIncludeAssessmentCriteria()==Boolean.TRUE ? "col-sm-4" : "col-sm-6" %> col-xs-12 text-center thr-block culture-fit" href="#2a" data-toggle="tab"    id="progress2"  onClick="tabToggle('#tab2', '.culture-fit')">
                        <label class="progress-label">culture fit</label>
                        <div class="<%= "percent-" + jobApplication.getCultureFitColor() + " fixed-width" %>">
                            <p style="display:none;"><oneit:toString value="<%= jobApplication.getCultureFitScore() %>" mode="TwoDPDouble" /></p>
                        </div>
                        <div class="row four-label">
                        <%
                            if(!cultureConcerns.isEmpty())
                            {
                                int rowCount    =   (cultureConcerns.size() % 2 == 0) ? (cultureConcerns.size() / 2) : ((cultureConcerns.size() + 1) / 2);
                                
                                for(int i = 0; i < rowCount; i++)
                                {
                                    Tuple.T2    firstTuple  =   cultureConcerns.get(i*2);
                                    Tuple.T2    secondTuple =   (cultureConcerns.size() > ((i*2) + 1)) ? cultureConcerns.get((i*2) + 1) : null;
                                    
                                    String      dotClass    =   ((ColorCode)firstTuple.get1()).getDotCSSClass();
                        %>
                                    <div class="a-label-row">
                                        <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + ((CultureElement)firstTuple.get0()).getObjectID() %>')">
                                            <span class="common-dot <%= dotClass %>"></span>
                                            <span class="r-y-label text-dot-dot">
                                                <oneit:toString value="<%= firstTuple.get0() %>"    mode="EscapeHTML"/>
                                            </span>
                                        </div>
                                    <%
                                        if(secondTuple != null)
                                        {
                                            dotClass    =   ((ColorCode)secondTuple.get1()).getDotCSSClass();
                                    %>
                                            <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + ((CultureElement)firstTuple.get0()).getObjectID() %>')">
                                                <span class="common-dot <%= dotClass %>"></span>
                                                <span class="r-y-label text-dot-dot">
                                                    <oneit:toString value="<%= secondTuple.get0() %>"   mode="EscapeHTML"/>
                                                </span>
                                            </div>
                                    <%
                                        }
                                    %>
                                    </div>
                        <%
                                }
                            }
                        %>
                        </div>
                    </div>
                    <%
                        if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                        {
                    %>
                            <div class="col-sm-4 col-xs-12 text-center thr-block requirement-fit" href="#3a" data-toggle="tab"    id="progress3"  onClick="tabToggle('#tab3','.requirement-fit')">
                                <label class="progress-label">requirements</label>
                                <div class="<%= "percent-" + jobApplication.getRequirementFitColor() + " fixed-width" %>">
                                    <p style="display:none;"><oneit:toString value="<%= jobApplication.getRequirementFitScore() %>" mode="TwoDPDouble" /></p>
                                </div>
                                <div class="row four-label">
                                    
                                    <%
                                        for(CriteriaType ct: CriteriaType.getCriteriaTypeArray())
                                        {
                                            MultiHashtable<Importance, AssessmentCriteriaAnswer> negativeAnswers    =   jobApplication.getNegativeACByImportance(ct);
                                            
                                            int essentialNo     =   negativeAnswers.getValuesForKeyNN(Importance.ESSENTIAL).size();
                                            int hDesirableNo    =   negativeAnswers.getValuesForKeyNN(Importance.HIGHLY_DESIRABLE).size();

                                            if(essentialNo == 0 && hDesirableNo == 0)
                                            {
                                                continue;
                                            }
                                    %>
                                            <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                                                <div class="a-label-row">
                                                    <span class="r-y-label pre-dot"><%= ct.getDescription() %></span>
                                                    <%
                                                        if(hDesirableNo > 0)
                                                        {
                                                    %>
                                                            <span class="common-dot yellow-dot"></span>
                                                            <span class="r-y-label pre-dot" onclick="focusReqDiv('.<%= Importance.HIGHLY_DESIRABLE %>')">(<%=hDesirableNo%>)</span>
                                                    <%
                                                        }
                                                            
                                                        if(essentialNo > 0)
                                                        {
                                                    %>
                                                            <span class="common-dot red-dot"></span>
                                                            <span class="r-y-label pre-dot" onclick="focusReqDiv('.<%= Importance.ESSENTIAL %>')">(<%=essentialNo%>)</span>
                                                    <%
                                                        }
                                                    %>
                                                </div> 
                                            </div>
                                    <%
                                        }
                                    %>
                                </div>
                            </div>

                    <%
                        }
                    %>
                </div>
                <div class="applicant-tab">
                    <div class="tab-content clearfix">
                        <div class="tab-pane active" id="1a">
                        <%
                            Map<FactorClass, Map<FactorLevelLink, Map>> factorClassDtls =   (Map<FactorClass, Map<FactorLevelLink, Map>>) jobApplication.getFactorScoreDetails();
                            
                            for(FactorClass factorClass : factorClassDtls.keySet())
                            {
                                Map<FactorLevelLink, Map>   factorDetails   =   factorClassDtls.get(factorClass);
                                Double                      rating          =   roleScoreMap.get(factorClass).get0();
                                ColorCode                   colorCode       =   roleScoreMap.get(factorClass).get1();
                                String                      cssClass        =   colorCode.getCSSClass();
                        %>
                                <div class="main-pro-bar">
                                    <div class="pro-bar">
                                        <span class="appli-label"><oneit:toString   value="<%= factorClass %>"  mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"  mode="PercentageWholeNumber"/></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar <%= cssClass %>" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%"></div>
                                            </div>
                                        </span>
                                        <span class="expand-box">
                                            <span class="hasarrow"><img src="images/select-down-arrow.svg"></span>
                                        </span>
                                    </div>

                                    <div class="expand-hide-tag">
                                    <%
                                        for(FactorLevelLink factorLevelLink : factorDetails.keySet())
                                        {
                                            Map factorLinkDetails   =   factorDetails.get(factorLevelLink);

                                            if(!factorLinkDetails.isEmpty())
                                            {
                                                FactorScore factorScore =   (FactorScore) factorLinkDetails.get("factorScore");
                                    %>
                                                <div class="tab-row" id="<%= factorScore.getObjectID() %>">
                                                    <div class="tab-view-label">
                                                        <oneit:toString value="<%= factorLevelLink.getFactor() %>"  mode="EscapeHTML"/>
                                                    </div>
                                                    <div class="tab-view-side">
                                                        <div class="result-want">
                                                            <div class="result"><oneit:toString value="<%= factorLevelLink.getLeftAnnot() %>"   mode="EscapeHTML"/></div>
                                                            <div class="wants"><oneit:toString  value="<%= factorLevelLink.getRightAnnot() %>"  mode="EscapeHTML"/></div>
                                                        </div>
                                                        <div class="result-bar">
                                                            <ul>
                                                            <%
                                                                Map<FactorScoreResult, Double>  factorScoreDetails  =   (Map<FactorScoreResult, Double>)factorLinkDetails.get("factorScoreDetails");

                                                                for(FactorScoreResult factorScoreResult : factorScoreDetails.keySet())
                                                                {
                                                            %>
                                                                    <li class="<%= factorScoreResult.getColorCode() != null ? factorScoreResult.getColorCode().getCSSClass() : "" %>"   style="width: <%= factorScoreDetails.get(factorScoreResult) %>%; height: 10px"></li>
                                                            <%
                                                                }
                                                            %>
                                                            </ul>
                                                            <span class="triangle-arrow" style="left: <%= factorLinkDetails.get("scoreLeftMargin")%>%;"></span>
                                                        </div>
                                                        <div class="like-strive"><oneit:toString    value="<%= factorScore != null ? factorScore.getNarrative() : null %>"  mode="EscapeHTML"/></div>
                                                    </div>
                                                </div>
                                    <%
                                            }
                                        }
                                    %>
                                    </div>
                                </div>
                        <%
                            }
                        %>
                        </div>
                        <div class="tab-pane" id="2a">
                            <%
                                Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>    cultureFitData  =   (Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>) jobApplication.getCultureFit();
                            
                                for(CultureClass cClass: cultureFitData.keySet())
                                {
                                    if(cClass == null || cultureFitData.get(cClass) == null)
                                    {
                                        continue;
                                    }
                                
                                    Long    rating  =   cultureFitData.get(cClass).get0();
                            %>
                                    <div class="main-pro-bar">
                                        <div class="pro-bar">
                                            <span class="appli-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></span>
                                            <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                            <span class="appli-progress-bar">
                                                <div class="progress">
                                                    <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%;"></div>
                                                </div>
                                            </span>
                                            <span class="expand-box">
                                            <span class="hasarrow"><img src="images/select-down-arrow.svg" /></span>
                                            </span>
                                        </div>
                                        <div class="expand-hide-tag">
                                            <%
                                                for(Tuple.T3 tuple : cultureFitData.get(cClass).get1())
                                                {
                                                    CultureNarrative    cultureNarrative    =   (CultureNarrative) tuple.get2();
                                                    String              dotClass            =   cultureNarrative != null && cultureNarrative.getColorCode() != null ? cultureNarrative.getColorCode().getDotCSSClass() : "";
                                            %>
                                                    <div class="detail-tab-row" id="<%= ((CultureElement)tuple.get1()).getObjectID() %>">
                                                        <div class="detail-tab-row-title col-md-4 col-sm-4 col-xs-4">
                                                            <span class="common-dot <%= dotClass %>"></span> &nbsp; 
                                                            <oneit:toString value="<%= tuple.get1() %>" mode="EscapeHTML"/>
                                                        </div>
                                                        <div class="detail-tab-row-text col-md-8 col-sm-8 col-xs-8">
                                                            <oneit:toString value="<%= cultureNarrative %>" mode="EscapeHTML"/>
                                                        </div>
                                                    </div>
                                            <%
                                                }
                                            %> 
                                        </div>
                                    </div>
                            <%
                                }
                            %>
                        </div>
                        <%
                            if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                            {
                        %>
                                <div class="tab-pane" id="3a">
                                    <%
                                        MultiHashtable<Importance, AssessmentCriteriaAnswer>    reqAnswersByImportance  =   jobApplication.getRequirementAnswersByImportance();
                                        Map<Importance, Long>   requirementFitData  =   (Map<Importance, Long>)jobApplication.getRequirementFit();

                                        for(Importance importance: Utils.getImportancesForAssessment())
                                        {
                                            Long    rating  =   requirementFitData.get(importance);
                                    %>
                                            <div class="main-pro-bar <%= importance %>">
                                                <div class="pro-bar">
                                                    <span class="appli-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></span>
                                                    <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                                    <span class="appli-progress-bar">
                                                        <div class="progress">
                                                            <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%"></div>
                                                        </div>
                                                    </span>
                                                    <%
                                                        if(reqAnswersByImportance.getValuesForKey(importance)!=null)
                                                        {
                                                    %>
                                                            <span class="expand-box">
                                                                <span class="hasarrow"><img src="images/select-down-arrow.svg" /></span>
                                                            </span>
                                                    <%
                                                        }
                                                    %>
                                                </div>
                                                <%
                                                    if(reqAnswersByImportance.getValuesForKey(importance)!=null)
                                                    {
                                                %>
                                                        <div class="expand-hide-tag">
                                                            <%
                                                                for(AssessmentCriteriaAnswer answer: reqAnswersByImportance.getValuesForKey(importance))
                                                                {
                                                                    String  dotClass    =   answer.getAnswer() ? "" : (importance == Importance.ESSENTIAL ? "red-dot" : (importance == Importance.HIGHLY_DESIRABLE ? "yellow-dot" : ""));
                                                            %>
                                                                    <div class="tab-row">
                                                                        <div class="detail-tab-row-title col-md-4 col-sm-4 col-xs-4" style="width: 30%">
                                                                            <span class="common-dot <%= dotClass %>"></span> &nbsp; 
                                                                            <oneit:toString value="<%= answer.getAssessmentCriteria().getCriteriaType() %>" mode="EscapeHTML"/>
                                                                        </div>
                                                                        <div class="detail-tab-row-text col-md-8 col-sm-8 col-xs-8" style="width: 65%">
                                                                            <oneit:toString value="<%= answer.getAssessmentCriteria() %>" mode="EscapeHTML"/>
                                                                            <span style="padding-left: 10px; float: right">
                                                                                <oneit:toString value="<%= answer.getAnswer() ? "Yes" : "No" %>" mode="EscapeHTML"/>
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                            <%
                                                                }
                                                            %>
                                                        </div>
                                                <%
                                                    }
                                                %>
                                            </div>
                                    <%
                                        }
                                    %>
                                </div>
                        <%
                            }
                        %>
                        <div class="tab-pane" id="4a">
                        </div>
                    </div>
                </div>
            </div>
            <div class="applicant-right">

                <div class="app-right-b">
                    <div class="overall-suit">overall rank</div>
                    <div class="big-percentage">                        
                        <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
                    </div>
                </div>
                <div class="applicant-contact-info">
                    <div class="contact-title">Contact</div>
                    <div class="contact-row">
                        <div class="contact-label">E</div>
                        <div class="contact-value">
                            <a href="<%= "mailto:" + candidate.getUser().getUserName() %>">
                                <oneit:toString value="<%= candidate.getUser().getUserName() %>" mode="EscapeHTML" />
                            </a>
                        </div>
                    </div>
                    <div class="contact-row">
                        <div class="contact-label">P</div>
                        <div class="contact-value">
                            <oneit:toString value="<%= candidate.getPhone() %>" mode="EscapeHTML" />
                        </div>
                    </div>
                    <div class="contact-row"    style="display: none;">
                        <div class="contact-label"><img src="images/linkdin-icon.png" /></div>
                        <div class="contact-value"><a href="#">View LinkedIn profile</a></div>
                    </div>
                    <div class="contact-row"    style="display: none;">
                        <div class="contact-label"><img src="images/download-icon.png" /></div>
                        <div class="contact-value"><a href="#">Download Resume</a></div>
                    </div>
                </div>
                <div class="applicant-note" style="display: none;">
                    <div class="applicant-note-title">Notes</div>
                    <div class="note-txt-box">
                        <textarea class="form-control"></textarea>
                        <input type="button" class="add-note-btn" value="ADD NOTE" />
                    </div>
                </div>
                <div class="admin-notes"    style="display: none;">
                    <div class="admin-name">Admin name</div>
                    <div class="date-value">TODAY</div>
                    <div class="admin-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent accumsan interdum nisi, sed laoreet dui rhoncus.</div>
                    <div class="admin-br-line"></div>
                    <div class="admin-name">Admin name</div>
                    <div class="date-value">2 days ago</div>
                    <div class="admin-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</div>
                </div>
            </div>
        </div>
    </div>
</div>

</oneit:dynIncluded>