import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { MessageTemplateModel } from '../../models/messageTemplateModel';
import { TemplateTypeModel } from '../../models/templateTypeModel';

import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class EditMessageTemplateService {

  constructor(
    private searchService: SearchService,
    private utilsService: UtilsService
  ) {
  }

  getMessageTemplateByID(id, assocs): Observable<any> {
    return this.searchService.getObjectById('MessageTemplates', id, assocs)
      .map(
        data => {
          const objs = this.utilsService.convertResponseToObjects(data, assocs);

          if (objs && objs.length > 0) {
            return objs[0];
          }
        }
      );
  }

}
