package performa.utils;

import oneit.utils.FormatterFactory;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.Job;
import performa.orm.types.AssessmentType;


public class AssessmentTypeEnumFormatter implements FormatterFactory
{
    private Job job;
    private AssessmentCriteriaTemplate  template;
    
    public AssessmentTypeEnumFormatter(Job job)
    {
        this.job = job;
    }
    
    public AssessmentTypeEnumFormatter(AssessmentCriteriaTemplate template)
    {
        this.template = template;
    }
    
    @Override
    public Object getFormatterFor(Object objectToFormat)
    {
        AssessmentType  assessmentType  =   ((AssessmentType) objectToFormat);
        AssessmentType  suggestedType   =   job != null ? job.getSuggestedAssessmentType() : template.getSuggestedAssessmentType();
        
        if(suggestedType == assessmentType)
        {
            return assessmentType.getDescription() +  " (Suggested)";
        }
        
        return assessmentType.getDescription();
    }
}