<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
 
<oneit:dynIncluded>
<%
    //TODO: filter with Client;
    SecUser secUser         =   SecUser.getTXUser(transaction);
    Job[]   jobs            =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(JobStatus.OPEN))
                                                .andCompanyUser(new EqualsFilter(secUser.getExtension(CompanyUser.REFERENCE_CompanyUser)))
                                                .search(transaction);
    
    Article jobsArticle     =   WebUtils.getArticleByShortCut(transaction, WebUtils.JOBS);
    String  nextPage        =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.VIEW_APPLICANTS).toMap());
    String  shortlistPage   =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.APPLICANTS_SHORTLIST).toMap());
    String  homePage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    String  jobsPage        =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "Page").toMap());
    boolean showModal       =   request.getParameter("showModal") != null ? Boolean.parseBoolean(request.getParameter("showModal")) : false;
%>
    <%
        if(showModal)
        {
    %>
            <script>
                $(document).ready(function(){
                    $('#welcomepopup').modal('show');
                });
            </script>
    <%
        }
    %>
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">
        <div class="dashboard-content-area">
        <div class="dashboard-first-part">
            <div class="welcome-box">
                <div class="dashboard-welcome">
                    <div class="welcome-text"> Welcome <br/> back <oneit:toString   value="<%= secUser.getFirstName()!=null ? secUser.getFirstName() : secUser.getUserName()%>"  mode="EscapeHTML"/>!</div>
                    <a class="d-create-job-btn" href="<%= jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.CREATE_JOB).toMap()) %>">Create a Job</a>
                </div>
                <div class="col-sm-3 col-xs-12 d-three-box green-light">
                    <div class="d-fl-left eq-height">
                        <div class="dash-count c-green">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobStatus", JobStatus.OPEN).toMap())
                                                                            .toMap() %>">
                                <oneit:toString value="<%= jobs.length %>"  mode="EscapeHTML"   nullValue="0"/>
                            </oneit:button>
                        </div>
                        <div class="d-box-title">Open Jobs</div>
                        <%
                            int closingSoonJobs =   Utils.getClosingSoonJobCount(jobs);
                            
                            if(closingSoonJobs > 0)
                            {
                        %>
                                <oneit:button   value=" "   name="navigateBetweenStatus"    skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                                .mapEntry("JobStatus", JobStatus.OPEN)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobSortOption", JobSortOption.CLOSING_SOON).toMap())
                                                                                .toMap() %>">
                                    <div class="arrow-btn">
                                        <oneit:toString value="<%= closingSoonJobs %>"  mode="Integer"  nullValue="0"/> closing soon 
                                    </div>
                                </oneit:button>
                        <%
                            }
                            else
                            {
                        %>
                                <div class="empty-area">&nbsp;</div>
                        <%
                            }
                        %>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-12 d-three-box gray-light">
                    <div class="d-fl-left eq-height">
                        <div class="dash-count c-gray">
                        <%
                            Job[]   filledJobs  =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(JobStatus.FILLED))
                                                                .andCompanyUser(new EqualsFilter<>(secUser.getExtension(CompanyUser.REFERENCE_CompanyUser)))
                                                                .search(transaction);
                            int     filledCount =   filledJobs != null ? filledJobs.length : 0;
                                    
                            if(filledCount > 0)
                            {
                        %>
                                <oneit:button   value=" "   name="navigateBetweenStatus"    skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobsPage)
                                                                                .mapEntry("JobStatus", JobStatus.FILLED)
                                                                                .toMap() %>">
                                        <oneit:toString value="<%= filledCount %>"  mode="Integer"  nullValue="0"/>
                                </oneit:button>
                        <%
                            }
                        %>
                            <%= filledCount == 0 ? "0" : "" %>
                        </div>
                        <div class="d-box-title">Jobs filled</div>
                        <div class="empty-area">&nbsp;</div>
                    </div>
                </div>
            </div>
        </div>
        <div class="second-part">
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            <div class="d-job-title">Open Jobs</div>
            
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_list.jsp" data="<%= CollectionUtils.EMPTY_MAP%>"  ShortlistPage="<%= shortlistPage %>"
                                NextPage="<%= nextPage%>"   HomePage="<%= homePage%>"   Jobs="<%= jobs %>"/>
        </div> 
        </div>
    </oneit:form>
        
    <div class="modal fade" id="welcomepopup" role="dialog">
        <div class="modal-dialog welcome-pop-top">
            <div class="modal-body main-welcome-popup">
                <h2>Welcome to your Dashboard!</h2>
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a porta ex, ac suscipit quam. Donec aliquam hendrerit odio, et vestibulum turpis porttitor u phasellus nec velit in nibh eleifend.</p>
                <div class="create-y-f-job">
                    <a href="<%= jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.CREATE_JOB).toMap()) %>">
                        Create your first job
                    </a>
                </div>
            </div>          
        </div>
    </div>
</oneit:dynIncluded>