<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="en">
    <head>
        <meta charset="utf-8"></meta>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"></meta>
        <meta name="viewport" content="width=device-width, initial-scale=1"></meta>
        <%
            Company     company     =   clientUser != null && clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser) != null
                                            ? clientUser.getExtension(CompanyUser.REFERENCE_CompanyUser).getCompany() : null;
        %>
        
        <title><%= "Talentology" + (company != null ? " - " + company.getCompanyName() : "")%></title>
        <%@include file="/inc/std_imports.jsp" %>
        <%@include file="/hotjar.jsp" %>
        <%@include file="/heapAnalysis.jsp" %>
    </head>
    <script>
        window.intercomSettings = {
          app_id: "kqed9h3r"
        };
    </script>
    <script>
        (function(){var w=window;var ic=w.Intercom;if(typeof ic==="function"){ic('reattach_activator');ic('update',intercomSettings);}else{var d=document;var i=function(){i.c(arguments)};i.q=[];i.c=function(args){i.q.push(args)};w.Intercom=i;function l(){var s=d.createElement('script');s.type='text/javascript';s.async=true;s.src='https://widget.intercom.io/widget/kqed9h3r';var x=d.getElementsByTagName('script')[0];x.parentNode.insertBefore(s,x);}if(w.attachEvent){w.attachEvent('onload',l);}else{w.addEventListener('load',l,false);}}})()
    </script>
    <body>
    <%
        Article home        =   WebUtils.getArticleByShortCut(objTran, WebUtils.ADMIN_HOME);
        String  homeUrl     = 	home.getLink(request);
        String  signoutUrl  = 	"logout.jsp?nextURL=" + homeUrl;
        
        if(clientUser != null)
        {
            StringBuilder   sb  =   new StringBuilder();
            
            if(clientUser.getFirstName()!=null)
            {
                sb.append(clientUser.getFirstName());
                sb.append(" ");
                
                if(clientUser.getLastName()!=null )
                {
                    sb.append(clientUser.getLastName().charAt(0));
                    sb.append(".");
                }
            }
            else
            {
                sb.append(clientUser.getUserName());
            }
    %>
            <header>
                <div class="container-fluid">
                    <div class="row">
                        <div class="site-logo">
                            <a href="#"><img src="images/logo.svg"></a>
                        </div>
                        <div class="search-bar">
                            <div class="inset-shadow"></div>
                            <img src="images/search-icon.svg"/>
                            <input type="text" class="form-control" placeholder="<%= company.getHasClientSupport() ? "Search for job, candidate or client" : "Search for a job or candidate"%>"/>
                        </div>
                        <div class="fl-right">
                            <div class="notification-bar">
                                <div class="tack-center">
                                    <a href="#" data-toggle="dropdown">
                                        <!--TODO: enable when there are notifications-->
                                        <!--<span class="notification-label"></span>-->
                                        <img src="images/notification-icon.svg">
                                    </a>
                                    <ul class="profile-dropdown dropdown-menu">
                                        <span class="arrow-up"></span>
                                        <li><a href="#">No new notifications</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="user-profile-dropdown">
                                <a href="#" class="user-name" data-toggle="dropdown">
                                    <oneit:toString value="<%= sb.toString() %>" mode="EscapeHTML"/>
                                    <img src="images/arrow.svg"/>
                                </a>
                                <ul class="profile-dropdown dropdown-menu">
                                    <span class="arrow-up"></span>
                                    <%
                                        Article myDetailsArticle =   WebUtils.getArticleByShortCut(objTran, WebUtils.MY_DETAILS);
                                    %>
                                        <li><a href="<%= myDetailsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "Page").toMap())%>">My Details</a></li>
                                        <li><a href="<%= signoutUrl %>">Sign Out</a></li>
                                </ul>
                            </div>
                            <div class="create-job-btn">
                                <%
                                    Article jobsArticle =   WebUtils.getArticleByShortCut(objTran, WebUtils.JOBS);
                                %>
                                <a href="<%= jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.CREATE_JOB).toMap()) %>">Create Job</a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            
            <script type="text/javascript">
                $(document).ready(function()
                {
                    if($('.dashboard-content-area').height() < $(window).height())
                    {
                        ($('.dashboard-content-area').hasClass('second-part') ) ? 
                        $('.dashboard-content-area').height($(window).height() - $('.dashboard-content-area').outerHeight() + $('.dashboard-content-area').height() - 65) : 
                        $('.second-part').innerHeight( $(window).height() - $('.dashboard-first-part').outerHeight() - 65 )
                    }
                });
            </script> 
    <%
        }
    %>
