package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.AssessmentCriteria;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class LoadRequirementsFromTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest          request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        AssessmentCriteriaTemplate  template    =   job.getAssessmentTemplate();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside LoadRequirementsFromTemplateFP for ", job, " load from template:", template);
        
        if(template != null)
        {
            for(AssessmentCriteria criteria : job.getAssessmentCriteriasSet())
            {
                criteria.delete();
            }

            for(AssessmentCriteria criteria : template.getAssessmentCriteriasSet())
            {
                AssessmentCriteria criteriaCopy = AssessmentCriteria.createAssessmentCriteria(objTran);

                criteriaCopy.copyAttributesFrom(criteria);
                
                job.addToAssessmentCriterias(criteriaCopy);
            }
        }
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "LoadRequirementsFromTemplateFP completed for ", job);
        
        return RedisplayResult.getInstance();
    }
}