
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import performa.orm.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class MessageTemplatePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea MessageTemplatePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "MessageTemplate");

    // Private attributes corresponding to business object data
    private Integer dummyMessageID;
    private String dummyTemplateName;
    private String dummySubject;
    private ApplicationStatus dummyApplicationStatus;
    private Integer dummyDelayHrs;
    private Integer dummyDelayMin;
    private Integer dummyVariance;
    private Boolean dummyBusinessHoursOnly;
    private String dummyMessageContent;
    private TemplateType dummyTemplateType;
    private Boolean dummyRelatedToJob;
    private Boolean dummyIsSystemGenerated;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_MessageID = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_TemplateName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Subject = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ApplicationStatus = new EnumeratedAttributeHelper (ApplicationStatus.FACTORY_ApplicationStatus);
    private static final DefaultAttributeHelper HELPER_DelayHrs = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_DelayMin = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Variance = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_BusinessHoursOnly = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MessageContent = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_TemplateType = new EnumeratedAttributeHelper (TemplateType.FACTORY_TemplateType);
    private static final DefaultAttributeHelper HELPER_RelatedToJob = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsSystemGenerated = DefaultAttributeHelper.INSTANCE;
    



    public MessageTemplatePersistenceMgr ()
    {
        dummyMessageID = (Integer)(HELPER_MessageID.initialise (dummyMessageID));
        dummyTemplateName = (String)(HELPER_TemplateName.initialise (dummyTemplateName));
        dummySubject = (String)(HELPER_Subject.initialise (dummySubject));
        dummyApplicationStatus = (ApplicationStatus)(HELPER_ApplicationStatus.initialise (dummyApplicationStatus));
        dummyDelayHrs = (Integer)(HELPER_DelayHrs.initialise (dummyDelayHrs));
        dummyDelayMin = (Integer)(HELPER_DelayMin.initialise (dummyDelayMin));
        dummyVariance = (Integer)(HELPER_Variance.initialise (dummyVariance));
        dummyBusinessHoursOnly = (Boolean)(HELPER_BusinessHoursOnly.initialise (dummyBusinessHoursOnly));
        dummyMessageContent = (String)(HELPER_MessageContent.initialise (dummyMessageContent));
        dummyTemplateType = (TemplateType)(HELPER_TemplateType.initialise (dummyTemplateType));
        dummyRelatedToJob = (Boolean)(HELPER_RelatedToJob.initialise (dummyRelatedToJob));
        dummyIsSystemGenerated = (Boolean)(HELPER_IsSystemGenerated.initialise (dummyIsSystemGenerated));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_message_template.object_id as id, {PREFIX}tl_message_template.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_message_template.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_message_template.message_id, {PREFIX}tl_message_template.template_name, {PREFIX}tl_message_template.subject, {PREFIX}tl_message_template.application_status, {PREFIX}tl_message_template.delay_hrs, {PREFIX}tl_message_template.delay_min, {PREFIX}tl_message_template.variance, {PREFIX}tl_message_template.business_hours_only, {PREFIX}tl_message_template.message_content, {PREFIX}tl_message_template.template_type, {PREFIX}tl_message_template.related_to_job, {PREFIX}tl_message_template.is_system_generated, {PREFIX}tl_message_template.hiring_team_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, MessageTemplate.REFERENCE_MessageTemplate);

                if (objectToReturn instanceof MessageTemplate)
                {
                    LogMgr.log (MessageTemplatePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a MessageTemplate");
                }
            }

            PersistentSet tl_message_templatePSet = allPSets.getPersistentSet(id, "tl_message_template", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_message_templatePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_MessageID)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_TemplateName)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_Subject)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_ApplicationStatus)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_DelayHrs)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_DelayMin)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_Variance)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_BusinessHoursOnly)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_MessageContent)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_TemplateType)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_RelatedToJob)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.FIELD_IsSystemGenerated)||
                    !tl_message_templatePSet.containsAttrib(MessageTemplate.SINGLEREFERENCE_HiringTeam))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (MessageTemplatePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                MessageTemplate result = new MessageTemplate ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_message_template " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_message_template.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (MessageTemplate.SINGLEREFERENCE_HiringTeam))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_message_template " +
                            "WHERE " + SELECT_JOINS + "hiring_team_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_message_templatePSet = allPSets.getPersistentSet(objectID, "tl_message_template");
            

            
            if (tl_message_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_message_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_message_template " +
                                                           "SET message_id = ?, template_name = ?, subject = ?, application_status = ?, delay_hrs = ?, delay_min = ?, variance = ?, business_hours_only = ?, message_content = ?, template_type = ?, related_to_job = ?, is_system_generated = ?, hiring_team_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_message_template.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_MessageID.getForSQL(dummyMessageID, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_MessageID))).listEntry (HELPER_TemplateName.getForSQL(dummyTemplateName, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_TemplateName))).listEntry (HELPER_Subject.getForSQL(dummySubject, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_Subject))).listEntry (HELPER_ApplicationStatus.getForSQL(dummyApplicationStatus, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_ApplicationStatus))).listEntry (HELPER_DelayHrs.getForSQL(dummyDelayHrs, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_DelayHrs))).listEntry (HELPER_DelayMin.getForSQL(dummyDelayMin, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_DelayMin))).listEntry (HELPER_Variance.getForSQL(dummyVariance, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_Variance))).listEntry (HELPER_BusinessHoursOnly.getForSQL(dummyBusinessHoursOnly, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_BusinessHoursOnly))).listEntry (HELPER_MessageContent.getForSQL(dummyMessageContent, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_MessageContent))).listEntry (HELPER_TemplateType.getForSQL(dummyTemplateType, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_TemplateType))).listEntry (HELPER_RelatedToJob.getForSQL(dummyRelatedToJob, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_RelatedToJob))).listEntry (HELPER_IsSystemGenerated.getForSQL(dummyIsSystemGenerated, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_IsSystemGenerated))).listEntry (SQLManager.CheckNull((Long)(tl_message_templatePSet.getAttrib (MessageTemplate.SINGLEREFERENCE_HiringTeam)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_message_template WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_message_template", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (MessageTemplatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_message_template");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_message_template for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (MessageTemplatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_message_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (MessageTemplatePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_message_templatePSet = allPSets.getPersistentSet(objectID, "tl_message_template");
        

        LogMgr.log (MessageTemplatePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_message_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_message_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_message_template " +
                                                       "WHERE tl_message_template.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_message_template WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_message_template");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_message_template for row:" + objectID;

                    LogMgr.log (MessageTemplatePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_message_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, MessageTemplate> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (MessageTemplate.REFERENCE_MessageTemplate.getObjectIDSpace (), r.getLong ("id"));
            MessageTemplate resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, MessageTemplate.REFERENCE_MessageTemplate);

                if (cachedElement instanceof MessageTemplate)
                {
                    LogMgr.log (MessageTemplatePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (MessageTemplate)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a MessageTemplate");
                }
            }
            else
            {
                PersistentSet tl_message_templatePSet = allPSets.getPersistentSet(objectID, "tl_message_template", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new MessageTemplate ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (MessageTemplatePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_message_template " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (MessageTemplate.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_message_template.object_id is not null
                    String preFilter = "(tl_message_template.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_message_template " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_message_templatePSet = allPSets.getPersistentSet(objectID, "tl_message_template", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_message_templatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_message_templatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_MessageID, HELPER_MessageID.getFromRS(dummyMessageID, r, "message_id"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_TemplateName, HELPER_TemplateName.getFromRS(dummyTemplateName, r, "template_name"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_Subject, HELPER_Subject.getFromRS(dummySubject, r, "subject"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_ApplicationStatus, HELPER_ApplicationStatus.getFromRS(dummyApplicationStatus, r, "application_status"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_DelayHrs, HELPER_DelayHrs.getFromRS(dummyDelayHrs, r, "delay_hrs"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_DelayMin, HELPER_DelayMin.getFromRS(dummyDelayMin, r, "delay_min"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_Variance, HELPER_Variance.getFromRS(dummyVariance, r, "variance"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_BusinessHoursOnly, HELPER_BusinessHoursOnly.getFromRS(dummyBusinessHoursOnly, r, "business_hours_only"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_MessageContent, HELPER_MessageContent.getFromRS(dummyMessageContent, r, "message_content"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_TemplateType, HELPER_TemplateType.getFromRS(dummyTemplateType, r, "template_type"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_RelatedToJob, HELPER_RelatedToJob.getFromRS(dummyRelatedToJob, r, "related_to_job"));
        tl_message_templatePSet.setAttrib(MessageTemplate.FIELD_IsSystemGenerated, HELPER_IsSystemGenerated.getFromRS(dummyIsSystemGenerated, r, "is_system_generated"));
        
        tl_message_templatePSet.setAttrib(MessageTemplate.SINGLEREFERENCE_HiringTeam, r.getObject ("hiring_team_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_message_templatePSet = allPSets.getPersistentSet(objectID, "tl_message_template");
        

        
        if (tl_message_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_message_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_message_template " +
                                     "  (message_id, template_name, subject, application_status, delay_hrs, delay_min, variance, business_hours_only, message_content, template_type, related_to_job, is_system_generated,  hiring_team_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_MessageID.getForSQL(dummyMessageID, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_MessageID))).listEntry (HELPER_TemplateName.getForSQL(dummyTemplateName, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_TemplateName))).listEntry (HELPER_Subject.getForSQL(dummySubject, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_Subject))).listEntry (HELPER_ApplicationStatus.getForSQL(dummyApplicationStatus, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_ApplicationStatus))).listEntry (HELPER_DelayHrs.getForSQL(dummyDelayHrs, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_DelayHrs))).listEntry (HELPER_DelayMin.getForSQL(dummyDelayMin, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_DelayMin))).listEntry (HELPER_Variance.getForSQL(dummyVariance, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_Variance))).listEntry (HELPER_BusinessHoursOnly.getForSQL(dummyBusinessHoursOnly, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_BusinessHoursOnly))).listEntry (HELPER_MessageContent.getForSQL(dummyMessageContent, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_MessageContent))).listEntry (HELPER_TemplateType.getForSQL(dummyTemplateType, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_TemplateType))).listEntry (HELPER_RelatedToJob.getForSQL(dummyRelatedToJob, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_RelatedToJob))).listEntry (HELPER_IsSystemGenerated.getForSQL(dummyIsSystemGenerated, tl_message_templatePSet.getAttrib (MessageTemplate.FIELD_IsSystemGenerated))) .listEntry (SQLManager.CheckNull((Long)(tl_message_templatePSet.getAttrib (MessageTemplate.SINGLEREFERENCE_HiringTeam)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_message_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
