package performa.form;

import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.security.LoginProcessor;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.utils.MultiException;
import oneit.utils.parsers.FieldException;
import performa.orm.CompanyUser;
import performa.utils.Utils;

/**
 *
 * @author nilu
 */
public class UserLoginFP extends LoginProcessor
{
    @Override
    protected void checkUserCanLogin(ObjectTransaction trans, SecUser userToCheck, SubmissionDetails submission, Map requestParams) throws FieldException, MultiException
    {
        super.checkUserCanLogin(trans, userToCheck, submission, requestParams);
                
        CompanyUser companyUser =   userToCheck.getExtension(CompanyUser.REFERENCE_CompanyUser);
        
        LogMgr.log(LOGIN, LogLevel.PROCESSING1,"In UserLoginFP checking user can log : ", companyUser );

        if(!Utils.checkAdminPortalAccess(userToCheck) || companyUser == null || !companyUser.isTrue(companyUser.getIsAccountVerified()))
        {
            throw new FieldException("You're not an authorised user to access this portal.", SecUser.FIELD_UserName);
        }
        else if(companyUser.isTrue(companyUser.getIsDisabled()))
        {
            throw new FieldException("Your account is disabled.", SecUser.FIELD_UserName);
        }
        else if(companyUser.getSelectedTeam() == null)
        {
            throw new FieldException("Your customer account is not active. Please contact Matchd <a href='https://matchd.com/support' target='_blank'>support</a> for assistance", SecUser.FIELD_UserName);
        }
        else if(companyUser.isTrue(companyUser.getIsEmailChanged())) 
        {
            //verify email address change
            companyUser.changeEmail(submission.getRequest());
        }
    }
    
    
    @Override
    public boolean shouldForcePasswordReset(SubmissionDetails submission, Map requestParameters, SecUser secUser) 
    {
        return false;
    }
}