package performa.utils;

import javax.servlet.http.HttpServletRequest;
import oneit.business.content.Article;
import oneit.business.content.transform.ContentTransformFactory;
import oneit.components.DefaultInitialisable;
import oneit.objstore.ObjectTransaction;
import oneit.utils.ObjectTransform;

/**
 *
 * @author Harsh
 */
public class BracklineSeparatorTransformFactory implements ContentTransformFactory, DefaultInitialisable
{
    @Override
    public ObjectTransform createTransform(Article article, HttpServletRequest request, ObjectTransaction transaction)
    {
        return new BracklineSeparatorTransform(article, request, transaction);
    }
    
    public class BracklineSeparatorTransform implements ObjectTransform
    {
        Article             article;
        HttpServletRequest  request;
        ObjectTransaction   transaction;

        public BracklineSeparatorTransform(Article article, HttpServletRequest request, ObjectTransaction transaction)
        {
            this.article        =   article;
            this.request        =   request;
            this.transaction    =   transaction;
        }
        
        @Override
        public Object transform(Object original)
        {
            if((Boolean)article.getAdditionalAttribute("Add Brackline Separator", Boolean.FALSE))
            {
                return String.valueOf(original);
            }
            else
            {
                return "";
            }
        }
    }
}