package performa.orm;

import oneit.objstore.*;
import oneit.objstore.cloning.*;


public class WorkFlowTemplate extends BaseWorkFlowTemplate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public WorkFlowTemplate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    private StandardAssocCopyingRule getCloneForCopy()
    {
        return new StandardAssocCopyingRule()
        {
            @Override
            protected Boolean shouldClone (BaseBusinessClass from,String assocName,BaseBusinessClass to)
            {
                if (to instanceof WorkFlowMessage || to instanceof WorkFlowTemplate)
                {
                    return Boolean.TRUE;
                }
                
                if (WorkFlowTemplate.MULTIPLEREFERENCE_WorkFlowStages.contentEquals(assocName))
                {
                    return Boolean.TRUE;
                }

                return null;
            }
        };
    }
    
    public WorkFlowTemplate getClonedTemplate()
    {
        return (WorkFlowTemplate) BusinessCopyHelper.copyRootBusinessObject (this, null, getCloneForCopy());
    }

    @Override
    public String getToString()
    {
        return getTemplateName();
    }
}