package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.MultiException;
import performa.orm.CompanyUser;
import performa.orm.JobApplication;
import performa.orm.Note;


public class ExtendJobFP extends SaveFP
{
    private static final LoggingArea  LOG =   LoggingArea.createLoggingArea("ExtendJobFP");
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException 
    {
        HttpServletRequest  request         =   submission.getRequest();
        JobApplication      jobApplication  =   (JobApplication) request.getAttribute("JobApplication");
        
        super.validate(process, submission, exceptions, params);
    }


    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        ObjectTransaction   objTran         =   process.getTransaction();
        HttpServletRequest  request         =   submission.getRequest();
        JobApplication      jobApplication  =   (JobApplication) request.getAttribute("JobApplication");
        
//        LogMgr.log(LOG, LogLevel.PROCESSING1, "Adding note to job application : ", jobApplication);
//
//        Note        note        =   Note.createNote(objTran);
//        SecUser     secUser     =   SecUser.getTXUser(process.getTransaction());
//        CompanyUser companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
//        
//        note.setComment(jobApplication.getNote());
//        note.setCreatedUser(companyUser);
//        note.setJobApplication(jobApplication);
//        
//        LogMgr.log(LOG, LogLevel.PROCESSING1, "New note added : ", note);

        return super.processForm(process, submission, params);
    }
}