<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    SecUser     loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company     company         =   companyUser.getCompany();
    HiringTeam  hiringTeam      =   (HiringTeam) process.getAttribute("HiringTeam");

    Debug.assertion(company != null , "Invalid company in admin portal my company");

    Debug.assertion(company != null , "Invalid hiring team in admin portal my company");
    
    String      nextPage        =   WebUtils.getSamePageInRenderMode(request, "Page");
%>
    <script type="text/javascript">
        $(document).ready(function()
        {
            recalcFunction = setupRecalc ($("editCompany"), {'recalcOnError':true});
            
            $("#upload").change(function(){
                readURL(this);
            });

            $("#remove-logo").click(function(){
                removeLogo();
            });
            
            
            $(".oneit-radio input").each(function(){
               
                 if($(this).is(':checked')) { 
                     updateRadioChecked(this); 
                 }
                 
                 $(this).click(function(){
                     if($(this).is(':checked')) { 
                     updateRadioChecked(this); 
                    }
                 });
            });
        });
        
        function updateRadioChecked(ele){
            $(".oneit-radio label").removeClass('checked');
            $(ele).closest('label').addClass('checked');
        }
    </script>    
    
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <h1 class="page-title"><%= hiringTeam.getHiringTeamName() %></h1>
                <div class="my-company-area">
                    <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                        
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>
                        
                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="1"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="company-detail">
                                    <div class="tabpage-title">
                                        <label class="label-20">Team Details</label>                
                                    </div>              
                                    <div class="form-group">
                                        <label><oneit:ormlabel  obj="<%= hiringTeam %>" field="HiringTeamName" /></label>
                                        <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="HiringTeamName" cssClass="form-control" />                                
                                    </div>
                                    <div class="form-group">
                                        <label><oneit:ormlabel  obj="<%= hiringTeam %>" field="HiringTeamLogo" /></label>
                                        <div class="main-upload-logo">
                                            <span class="u-img-tag" style="<%= hiringTeam.getHiringTeamLogo() != null ? "" : "display: none" %>">
                                                <tagfile:img    src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(hiringTeam.getHiringTeamLogo()), "KEEP", new ScaleWithin (0,90)) %>"
                                                                class="upload-img-w-h"  id="client-logo"/>
                                                <span class="remove-logo-btn">
                                                    <img src="images/logo-remove-btn.png" id="remove-logo">
                                                    <oneit:ormInput obj="<%= hiringTeam %>" type="text" attributeName="IsLogoDeleted"  style="display:none;" />
                                                </span>
                                            </span>

                                            <span class="up-rep-btn">
                                                <oneit:ormInput obj="<%= hiringTeam %>" type="file" attributeName="HiringTeamLogo"  accept="image/*"    id="upload"
                                                                style="visibility: hidden; width: 1px; height: 1px"/>
                                                <a href="javascript:void(0)" onclick="document.getElementById('upload').click(); return false" id="replace-btn">
                                                    <%= hiringTeam.getHiringTeamLogo() != null ? "Replace" : "Upload" %>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label><oneit:label GUIName="Industry" /></label>
                                            <oneit:ormEnum  obj="<%= hiringTeam %>"    attributeName="Industry"    cssClass="form-control" displayType="autocomplete"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="styled_checkboxes">
                                            <div class="checkbox checkbox-primary">
                                                <oneit:ormInput obj="<%= hiringTeam %>"  id="has-client-support"  attributeName="HasClientSupport" type="checkbox"/>
                                                <oneit:recalcClass  htmlTag="span"  classScript="hiringTeam.showHasClientSupport() ? 'checked': 'unchecked'"    hiringTeam="<%= hiringTeam %>">
                                                    <label for="has-client-support">
                                                        <oneit:ormlabel  obj="<%= hiringTeam %>"    field="HasClientSupport" />
                                                    </label>
                                                </oneit:recalcClass>
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="form-brack-line-sub"></div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label><oneit:label GUIName="Will this team manage its own billing?" /></label>
                                        </div>
                                        <oneit:recalcClass  htmlTag="div"  classScript="hiringTeam.getManageOwnBilling() ? 'show': 'hide'"  hiringTeam="<%= hiringTeam %>">
                                            <label><oneit:label GUIName="Which team will manage the billing?"/></label>
                                        </oneit:recalcClass>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <div class="radio radio-primary second-radio-primary oneit-radio">
                                                <label >
                                                <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="ManageOwnBilling" value="true"/>Yes
                                                </label>
                                            </div>
                                             <div class="radio radio-primary second-radio-primary oneit-radio">
                                                <label>
                                                <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="ManageOwnBilling" value="false"/>No
                                                </label>
                                            </div>
                                        </div>
                                        <div id="billing_team" class="<%= "col-md-6 " +  (hiringTeam.getManageOwnBilling() ? "hide" : "show") %>" >
                                            <div class="wider-select">
                                                <tagfile:ormsingleasso_select obj="<%= hiringTeam %>"  assocName="BillingTeam" options="<%= Utils.getOtherHiringTeams(hiringTeam) %>"/>
                                            </div>                                        
                                        </div>
                                    </div>
                                    <div class="form-brack-line-sub"></div>

                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <label><oneit:ormlabel  obj="<%= hiringTeam %>"    field="Country" /></label>
                                            <oneit:ormEnum  obj="<%= hiringTeam %>"    attributeName="Country" cssClass="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                            <label><oneit:ormlabel  obj="<%= hiringTeam %>"    field="State" /></label>
                                            <oneit:ormEnum  obj="<%= hiringTeam %>"    attributeName="State" cssClass="form-control"/>
                                        </div>
                                        <div class="col-md-4">
                                            <label><oneit:ormlabel  obj="<%= hiringTeam %>"    field="PostCode" /></label>
                                            <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="PostCode"    cssClass="form-control" />      
                                        </div>
                                    </div>  
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label><oneit:ormlabel  obj="<%= hiringTeam %>"    field="City" /></label>
                                            <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="City"    cssClass="form-control" />      
                                        </div>
                                        <div class="col-md-6">
                                            <label><oneit:label GUIName="Default Timezone" /></label>
                                            <oneit:ormEnum  obj="<%= hiringTeam %>"    attributeName="TimeZone"    cssClass="form-control"/>
                                        </div>
                                    </div>  
                                    <div class="text-center form-group">
                                        <oneit:button   value="Save Updates"    name="saveCompany"  cssClass="btn btn-primary largeBtn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap())
                                                                                            .mapEntry("Company", company)
                                                                                            .toMap() %>" />
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </oneit:form>
                </div>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
