<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ page import="oneit.utils.filter.CollectionFilter"%>

<oneit:dynIncluded>
<%
    String                  currentPage     =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.MY_COMPANY).getLink(request);
    String                  hiringTeamPage  =   WebUtils.getSamePageInRenderMode(request, "HiringTeam");
    ObjectTransaction       objTran         =   process.getTransaction ();
    SecUser                 secUser         =   SecUser.getTXUser(objTran);
    Company                 company         =   (Company) process.getAttribute("Company");
    CompanyUser             comUser         =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    UserSortOption          userSortOpt     =   (UserSortOption) process.getAttribute("UserSortOption");
    Collection<CompanyUser> companyUsers    =   (Collection<CompanyUser>) process.getAttribute("CompanyUsers");
    
    if(company == null)
    {
        company =   comUser.getCompany();
        process.setAttribute("Company", company);
    }
        
    if(companyUsers == null)
    {
        companyUsers    =   CollectionFilter.filter(company.getUsersSet(), CompanyUser.SearchByAll().andIsAccountVerified(new EqualsFilter<>(Boolean.TRUE)));
        
        process.setAttribute("CompanyUsers", companyUsers);
    }
    
    if( request.getParameter("UserSortOption") != null)
    {
        userSortOpt =   UserSortOption.forName((String) request.getParameter("UserSortOption"));
    }
    
    if(userSortOpt == null)
    {
        userSortOpt =   UserSortOption.ALPHA_A_Z;
    }
    
    process.setAttribute("UserSortOption", userSortOpt);
    
    Collection<HiringTeam> sortedHiringTeams    =   Utils.getHiringTeamsSorted(company.getHiringTeamsSet(), userSortOpt);
%>
    <oneit:form name="listHiringTeams" method="post"    enctype="multipart/form-data">

        <script type="text/javascript">
            $(document).ready(function()
            {
                recalcFunction = setupRecalc ($("listHiringTeams"), {'recalcOnError':true});
            });
        </script>    
    
        <div class="dashboard-content-area second-part">
                        
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="eq-justify-content">
                <div class="manage-user-left">
                    <div class="jobs-list-shorting">
                        <div class="d-job-title all-jobs-title">Hiring Teams</div>
                        <div class="shorting-dropdown">
                            <span class="order-label">order by</span>
                            <select class="form-control"    onChange="location=this.value">
                            <%
                                for (UserSortOption  sortOption : UserSortOption.getUserSortOptionArray())
                                {
                                    String  optionLink  =    currentPage + "?UserSortOption=" + sortOption.getName() ;
                            %>
                                    <option <%= (userSortOpt != null && userSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                        <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                    </option>
                            <%
                                }
                            %>
                            </select>
                        </div>
                    </div>
                    <div class="main-manage-userlist">
                    <%
                        for(HiringTeam  hiringTeam : sortedHiringTeams)
                        {
                    %>
                            <div class="user-list-row">
                                <div class="m-user-left">
                                    <!--TODO: add hiring team icon--> 
                                    <div class="m-user-icon"><img src="images/user-list-icon.png"></div>
                                    <div class="m-user-info">
                                        <div class="m-user-name">
                                            <oneit:toString value="<%= hiringTeam.getHiringTeamName() %>"  mode="EscapeHTML" />
                                        </div>
                                        <div class="m-user-email">
                                            Owner: <oneit:toString value="<%= hiringTeam.getAddedByUser() %>"  mode="EscapeHTML" />
                                        </div>
                                    </div>
                                </div>
                                <div class="m-user-right-padlock">
                                    <oneit:button   value=" "    name="gotoPage"    skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", hiringTeamPage)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap())
                                                                                .toMap() %>">
                                        <span class="m-user-right-padlockicon"><img src="images/m-user-right-padlockicon.png"></span>
                                    </oneit:button>
                                </div>
                            </div>
                    <%
                        }
                    %>
                    </div>
                </div>
                <div class="manage-user-right">
                    <div class="sidebar-title">
                        Add Hiring Team
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Hiring Team Name" /></label>
                        <oneit:ormInput obj="<%= company %>"    type="text" attributeName="HiringTeamName"   cssClass="form-control"    />
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Team Owner/Admin" /></label>
                        <div class="wider-select">
                            <tagfile:ormsingleasso_select obj="<%= company %>"  assocName="Owner"  options="<%= companyUsers.toArray(new CompanyUser[0]) %>"/>
                        </div> 
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Billing" /></label>
                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= company %>"  id="manage-own-billing"  attributeName="ManageOwnBilling" type="checkbox"/>
                                <oneit:recalcClass  htmlTag="span"  classScript="company.showTeamManagesOwnBilling() ? 'checked': 'unchecked'"    company="<%= company %>">
                                    <label for="manage-own-billing">
                                        <oneit:ormlabel  obj="<%= company %>"    field="ManageOwnBilling" />
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Select Billing Team" /></label>
                        <div class="wider-select">
                            <tagfile:ormsingleasso_select obj="<%= company %>"  assocName="BillingTeam" options="<%= company.getHiringTeamsSet().toArray(new HiringTeam[0]) %>"/>
                        </div> 
                    </div>
                    <oneit:button   value="Add Team"  name="addHiringTeam"  cssClass="btn btn-invite"   
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                    .toMap() %>" />
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
