package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.CollectionUtils;
import oneit.utils.MultiException;
import performa.intercom.utils.IntercomUtils;
import performa.orm.Company;
import performa.orm.HiringTeam;
import performa.utils.StripeUtils;


public class SaveCompanyFP  extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        Company             company     =   process.getAttribute("Company") != null ? (Company) process.getAttribute("Company") : (Company) request.getAttribute("Company");
        HiringTeam          hiringTeam  =   (HiringTeam) process.getAttribute("HiringTeam");
        Boolean             isPayment   =   (Boolean) request.getAttribute("IsPayment");

        LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyFP saving company : ", company );
        
        if(CollectionUtils.equals(hiringTeam.getIsLogoDeleted(), Boolean.TRUE))
        {
            hiringTeam.setHiringTeamLogo(null);
            
            LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyFP setting hiring team logo to null of hiring team : ", hiringTeam );
        }
        
        if(hiringTeam.getManageOwnBilling())
        {
            hiringTeam.setBillingTeam(null);
        }
        
        if(CollectionUtils.equals(isPayment, Boolean.TRUE) && company.getPaymentJobCount()!=null)
        {
            company.setPaymentPlan(company.getSelectedPaymentPlan());
            
            LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"Company payment plan updated.", company, company.getPaymentPlan());
            
            if(company.getCardID() != null )
            {
                // cannot subscribe a user to a plan without card details
                StripeUtils.updatePlan(company);
                
                LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"Strpe subscription updated.", company, company.getStripeSubscription());
            }
        }
        
        // Update company in intercom
        IntercomUtils.updateCompany(company);
        
        return super.processForm(process, submission, params);
    }
    
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        Company             company     =   process.getAttribute("Company") != null ? (Company) process.getAttribute("Company") : (Company) request.getAttribute("Company");
        Boolean             isPayment   =   (Boolean) request.getAttribute("IsPayment");
        HiringTeam          hiringTeam  =   (HiringTeam) process.getAttribute("HiringTeam");

        //to select payment plan when job open
        if(CollectionUtils.equals(isPayment, Boolean.TRUE) && company.getPaymentJobCount()!=null)
        {
            BusinessObjectParser.assertFieldCondition(company.getSelectedPaymentPlan()!= null, company , Company.SINGLEREFERENCE_PaymentPlan, "mandatory", exceptions, true, request);
        }
        
        if(hiringTeam != null && !hiringTeam.getManageOwnBilling())
        {
            BusinessObjectParser.assertFieldCondition(hiringTeam.getBillingTeam() != null, hiringTeam , HiringTeam.SINGLEREFERENCE_BillingTeam, "mandatory", exceptions, true, request);
        }
        
        super.validate(process, submission, exceptions, params);
    }
}